/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;

public class CompositeConverter
implements Converter {
    private String name;
    private LinkedList<Converter> chain;

    public CompositeConverter(Converter ... converters) {
        if (converters.length == 0) {
            throw new IllegalArgumentException("There must be at least one converter");
        }
        this.chain = new LinkedList();
        this.name = this.compositeConverterName(converters);
    }

    private String compositeConverterName(Converter[] converters) {
        StringBuilder builder = new StringBuilder();
        for (Converter converter : converters) {
            this.chain.addLast(converter);
            builder.append(converter.getName());
        }
        return builder.toString();
    }

    @Override
    public boolean isSourceTypeSupported(Class<?> aClass) {
        return this.chain.size() > 0 && this.chain.peekFirst().isSourceTypeSupported(aClass);
    }

    @Override
    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return this.chain.size() > 0 && this.chain.peekFirst().isSourceDataTypeSupported(dataType);
    }

    @Override
    public List<Class<?>> getSourceTypes() {
        return this.chain.peekFirst().getSourceTypes();
    }

    @Override
    public List<DataType<?>> getSourceDataTypes() {
        return this.chain.peekFirst().getSourceDataTypes();
    }

    @Override
    public boolean isAcceptNull() {
        return this.chain.size() > 0 && this.chain.peekFirst().isAcceptNull();
    }

    @Override
    public boolean isIgnoreBadInput() {
        return this.chain.size() > 0 && this.chain.peekFirst().isIgnoreBadInput();
    }

    @Override
    public Object transform(Object src) throws TransformerException {
        return this.transform(src, null);
    }

    @Override
    public Object transform(Object src, String encoding) throws TransformerException {
        Object current = src;
        String currentEncoding = encoding;
        for (Converter converter : this.chain) {
            current = currentEncoding != null ? converter.transform(current, currentEncoding) : converter.transform(current);
            currentEncoding = converter.getEncoding();
        }
        return current;
    }

    @Override
    public void setReturnClass(Class<?> theClass) {
        if (this.chain.size() > 0) {
            this.chain.peekLast().setReturnClass(theClass);
            return;
        }
        throw new IllegalStateException("Cannot set return class on an empty converter chain");
    }

    @Override
    public Class<?> getReturnClass() {
        return this.chain.peekLast().getReturnClass();
    }

    @Override
    public void setReturnDataType(DataType<?> type) {
        this.chain.peekLast().setReturnDataType(type);
    }

    @Override
    public DataType<?> getReturnDataType() {
        return this.chain.peekLast().getReturnDataType();
    }

    @Override
    public String getMimeType() {
        return this.chain.peekLast().getMimeType();
    }

    @Override
    public String getEncoding() {
        return this.chain.peekLast().getEncoding();
    }

    @Override
    public ImmutableEndpoint getEndpoint() {
        return this.chain.peekFirst().getEndpoint();
    }

    @Override
    public void dispose() {
        for (Converter converter : this.chain) {
            converter.dispose();
        }
    }

    @Override
    public void setEndpoint(ImmutableEndpoint ep) {
        for (Converter converter : this.chain) {
            converter.setEndpoint(ep);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        for (Converter converter : this.chain) {
            converter.initialise();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (event != null && event.getMessage() != null) {
            try {
                event.getMessage().applyTransformers(event, this);
            }
            catch (Exception e) {
                throw new TransformerMessagingException(event, this, (Throwable)e);
            }
        }
        return event;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        for (Converter converter : this.chain) {
            converter.setMuleContext(context);
        }
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Cannot change composite converter name");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriorityWeighting() {
        int priorityWeighting = 0;
        for (Converter converter : this.chain) {
            priorityWeighting += converter.getPriorityWeighting();
        }
        return priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
    }

    public LinkedList<Converter> getConverters() {
        return new LinkedList<Converter>(this.chain);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name: " + this.getName() + "; chain: " + this.getConverters().toString() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        try {
            CompositeConverter compositeConverter = (CompositeConverter)o;
            if (!this.getName().equals(compositeConverter.getName())) {
                return false;
            }
            return this.getConverters().equals(compositeConverter.getConverters());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.getConverters());
    }
}

