/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.graph.SynchronizedTransformationGraph;
import org.mule.transformer.graph.TransformationEdge;

public class TransformationGraphLookupStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SynchronizedTransformationGraph graph;

    public TransformationGraphLookupStrategy(SynchronizedTransformationGraph graph) {
        this.graph = graph;
    }

    public List<Converter> lookupConverters(DataType<?> source, DataType<?> target) {
        List<Converter> converters = new LinkedList<Converter>();
        if (!this.graph.containsVertex(source)) {
            return converters;
        }
        if (!this.graph.containsVertex(target)) {
            return converters;
        }
        HashSet visited = new HashSet();
        List<List<TransformationEdge>> transformationPaths = this.findTransformationPaths(source, target, visited);
        converters = this.createConverters(transformationPaths);
        return converters;
    }

    private List<Converter> createConverters(List<List<TransformationEdge>> transformationPaths) {
        HashSet<CompositeConverter> converters = new HashSet<CompositeConverter>();
        for (List<TransformationEdge> transformationPath : transformationPaths) {
            Converter[] pathConverters = new Converter[transformationPath.size()];
            int index = 0;
            for (TransformationEdge edge : transformationPath) {
                pathConverters[index++] = edge.getConverter();
            }
            Converter converter = transformationPath.size() == 1 ? transformationPath.get(0).getConverter() : new CompositeConverter(pathConverters);
            converters.add((CompositeConverter)converter);
        }
        return new ArrayList<Converter>(converters);
    }

    private List<List<TransformationEdge>> findTransformationPaths(DataType<?> source, DataType<?> target, Set<DataType<?>> visited) {
        LinkedList<List<TransformationEdge>> validTransformationEdges = new LinkedList<List<TransformationEdge>>();
        if (visited.contains(source)) {
            return validTransformationEdges;
        }
        visited.add(source);
        Set<TransformationEdge> transformationEdges = this.graph.outgoingEdgesOf(source);
        for (TransformationEdge transformationEdge : transformationEdges) {
            DataType<?> edgeTarget = this.graph.getEdgeTarget(transformationEdge);
            if (edgeTarget.equals(target)) {
                LinkedList<TransformationEdge> transformationEdges1 = new LinkedList<TransformationEdge>();
                transformationEdges1.add(transformationEdge);
                validTransformationEdges.add(transformationEdges1);
                continue;
            }
            List<List<TransformationEdge>> newTransformations = this.findTransformationPaths(edgeTarget, target, visited);
            for (List<TransformationEdge> transformationEdgeList : newTransformations) {
                transformationEdgeList.add(0, transformationEdge);
                validTransformationEdges.add(transformationEdgeList);
            }
        }
        visited.remove(source);
        return validTransformationEdges;
    }
}

