/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.store.AbstractMonitoredObjectStore;

public class InMemoryObjectStore<T extends Serializable>
extends AbstractMonitoredObjectStore<T> {
    protected ConcurrentSkipListMap<Long, StoredObject<T>> store = new ConcurrentSkipListMap();

    @Override
    public boolean isPersistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("id"));
        }
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            return this.store.values().contains(new StoredObject<Object>(key, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Serializable id, T value) throws ObjectStoreException {
        if (id == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("id"));
        }
        StoredObject<T> obj = new StoredObject<T>(id, value);
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            if (this.store.values().contains(obj)) {
                throw new ObjectAlreadyExistsException();
            }
            boolean written = false;
            while (!written) {
                Long key = System.nanoTime();
                written = this.store.put(key, obj) == null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry(key);
            if (entry != null) {
                StoredObject object = (StoredObject)entry.getValue();
                return (T)((Serializable)object.getItem());
            }
        }
        throw new ObjectDoesNotExistException(CoreMessages.objectNotFound(key));
    }

    private Map.Entry<?, ?> findEntry(Serializable key) {
        for (Map.Entry<Long, StoredObject<T>> entry : this.store.entrySet()) {
            StoredObject<T> object = entry.getValue();
            if (!object.getId().equals(key)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry(key);
            if (entry != null) {
                StoredObject<T> removedObject = this.store.remove(entry.getKey());
                return (T)((Serializable)removedObject.getItem());
            }
        }
        throw new ObjectDoesNotExistException(CoreMessages.objectNotFound(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            this.store.clear();
        }
    }

    protected int expireAndCount() {
        Long oldestKey;
        long oldestKeyValue;
        Map.Entry<Long, StoredObject<T>> oldestEntry;
        int expiredEntries = 0;
        long now = System.nanoTime();
        while ((oldestEntry = this.store.firstEntry()) != null && TimeUnit.NANOSECONDS.toMillis(now - (oldestKeyValue = (oldestKey = oldestEntry.getKey()).longValue())) >= (long)this.entryTTL) {
            this.store.remove(oldestKey);
            ++expiredEntries;
        }
        return expiredEntries;
    }

    protected boolean isTrimNeeded(int currentSize) {
        return currentSize > this.maxEntries;
    }

    protected boolean isExpirationNeeded() {
        int currentSize = this.store.size();
        return this.entryTTL > 0 && currentSize != 0;
    }

    @Override
    protected boolean shouldExpire() {
        return true;
    }

    @Override
    public void expire() {
        int expiredEntries = this.doTrimAndExpire();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
        }
    }

    protected int doTrimAndExpire() {
        int expiredEntries = 0;
        if (this.isTrimNeeded(this.store.size())) {
            expiredEntries += this.trimToMaxSize(this.store.size());
        }
        if (this.isExpirationNeeded()) {
            expiredEntries = this.trimToMaxSize(this.store.size());
            expiredEntries += this.expireAndCount();
        }
        return expiredEntries;
    }

    private int trimToMaxSize(int currentSize) {
        if (this.maxEntries < 0) {
            return 0;
        }
        int excess = currentSize - this.maxEntries;
        if (excess > 0) {
            while (currentSize > this.maxEntries) {
                this.store.pollFirstEntry();
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + excess + " excess entries"));
            }
            return excess;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.store;
    }

    protected static class StoredObject<T> {
        private Serializable id;
        private T item;

        public StoredObject(Serializable id, T item) {
            this.id = id;
            this.item = item;
        }

        public Serializable getId() {
            return this.id;
        }

        public T getItem() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredObject that = (StoredObject)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("StoredObject");
            sb.append("{id='").append(this.id).append('\'');
            sb.append(", item=").append(this.item);
            sb.append('}');
            return sb.toString();
        }
    }
}

