/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation;

import java.util.List;
import org.mule.module.apikit.exception.BadRequestException;
import org.mule.raml.implv2.v10.model.MimeTypeImpl;
import org.mule.raml.interfaces.model.IMimeType;
import org.raml.v2.api.model.common.ValidationResult;

public class BodyValidator {
    private final IMimeType mimeType;

    public BodyValidator(IMimeType mimeType) {
        this.mimeType = mimeType;
    }

    public void validateSchemaV2(boolean isJsonMimeType, String payload) throws BadRequestException {
        if (this.mimeType instanceof MimeTypeImpl) {
            if (isJsonMimeType && !this.payloadIsJson(payload)) {
                throw new BadRequestException("Expected JSON body");
            }
            if (!isJsonMimeType && !this.payloadIsXML(payload)) {
                throw new BadRequestException("Expected XML body");
            }
        } else {
            throw new RuntimeException("not supported");
        }
        List validationResults = ((MimeTypeImpl)this.mimeType).validate(payload);
        if (!validationResults.isEmpty()) {
            String message = ((ValidationResult)validationResults.get(0)).getMessage();
            throw new BadRequestException(message);
        }
    }

    private boolean payloadIsXML(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().startsWith("<");
    }

    private boolean payloadIsJson(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().startsWith("{") || value.trim().startsWith("[");
    }
}

