/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;

public class ForNode
extends IterNode {
    private Node iterNode;

    public ForNode(ISourcePosition position, Node varNode, Node bodyNode, Node iterNode, StaticScope scope, int endLine) {
        super(position, varNode, scope, bodyNode, endLine);
        assert (iterNode != null) : "iterNode is not null";
        this.iterNode = iterNode;
    }

    @Override
    public ArgsNode getArgsNode() {
        throw new IllegalArgumentException("For nodes are not technically def nodes so they do not have args");
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FORNODE;
    }

    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitForNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.getVarNode(), this.getBodyNode(), this.iterNode);
    }
}

