/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connector;
import org.mule.config.MutableThreadingProfile;
import org.mule.transport.ConnectException;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequestDispatcherWork;
import org.mule.util.concurrent.ThreadNameHelper;

class HttpRequestDispatcher
implements Work {
    private static Log logger = LogFactory.getLog(HttpRequestDispatcher.class);
    private ServerSocket serverSocket;
    private HttpConnector httpConnector;
    private RetryPolicyTemplate retryTemplate;
    protected ExecutorService requestHandOffExecutor;
    private WorkManager workManager;
    private final AtomicBoolean disconnect = new AtomicBoolean(false);

    public HttpRequestDispatcher(HttpConnector httpConnector, RetryPolicyTemplate retryPolicyTemplate, ServerSocket serverSocket, WorkManager workManager) {
        if (httpConnector == null) {
            throw new IllegalArgumentException("HttpConnector can not be null");
        }
        if (retryPolicyTemplate == null) {
            throw new IllegalArgumentException("RetryPolicyTemplate can not be null");
        }
        if (serverSocket == null) {
            throw new IllegalArgumentException("ServerSocket can not be null");
        }
        if (workManager == null) {
            throw new IllegalArgumentException("WorkManager can not be null");
        }
        this.httpConnector = httpConnector;
        this.retryTemplate = retryPolicyTemplate;
        this.serverSocket = serverSocket;
        this.workManager = workManager;
        this.requestHandOffExecutor = this.createRequestDispatcherThreadPool(httpConnector);
    }

    private ExecutorService createRequestDispatcherThreadPool(HttpConnector httpConnector) {
        ThreadingProfile receiverThreadingProfile = httpConnector.getReceiverThreadingProfile();
        MutableThreadingProfile dispatcherThreadingProfile = new MutableThreadingProfile(receiverThreadingProfile);
        dispatcherThreadingProfile.setThreadFactory(null);
        dispatcherThreadingProfile.setMaxThreadsActive(dispatcherThreadingProfile.getMaxThreadsActive() * 2);
        String threadNamePrefix = ThreadNameHelper.getPrefix((MuleContext)httpConnector.getMuleContext()) + "http.request.dispatch." + this.serverSocket.getLocalPort();
        ExecutorService executorService = dispatcherThreadingProfile.createPool(threadNamePrefix);
        return executorService;
    }

    public void run() {
        while (!this.disconnect.get()) {
            if (!this.httpConnector.isStarted() || this.disconnect.get()) continue;
            try {
                this.retryTemplate.execute(new RetryCallback(){

                    public void doWork(RetryContext context) throws Exception {
                        Socket socket;
                        block3: {
                            socket = null;
                            try {
                                socket = HttpRequestDispatcher.this.serverSocket.accept();
                            }
                            catch (Exception e) {
                                if (HttpRequestDispatcher.this.httpConnector.isDisposed() || HttpRequestDispatcher.this.disconnect.get()) break block3;
                                throw new ConnectException((Throwable)e, null);
                            }
                        }
                        if (socket != null) {
                            HttpRequestDispatcherWork httpRequestDispatcherWork = new HttpRequestDispatcherWork(HttpRequestDispatcher.this.httpConnector, socket);
                            HttpRequestDispatcher.this.requestHandOffExecutor.execute(httpRequestDispatcherWork);
                        }
                    }

                    public String getWorkDescription() {
                        String hostName = ((InetSocketAddress)HttpRequestDispatcher.this.serverSocket.getLocalSocketAddress()).getHostName();
                        int port = ((InetSocketAddress)HttpRequestDispatcher.this.serverSocket.getLocalSocketAddress()).getPort();
                        return String.format("%s://%s:%d", HttpRequestDispatcher.this.httpConnector.getProtocol(), hostName, port);
                    }

                    public Connector getWorkOwner() {
                        return HttpRequestDispatcher.this.httpConnector;
                    }
                }, this.workManager);
            }
            catch (Exception e) {
                this.httpConnector.getMuleContext().getExceptionListener().handleException(e);
            }
        }
    }

    public void release() {
    }

    void disconnect() {
        this.disconnect.set(true);
        try {
            if (this.serverSocket != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closing: " + this.serverSocket));
                }
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to close server socket: " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.requestHandOffExecutor.shutdown();
        }
    }
}

