/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.mule.api.util.CredentialsMaskUtil;
import org.mule.module.db.internal.domain.connection.AbstractConnectionFactory;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConnectionFactory
extends AbstractConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Class<?>> typeMapping;

    public SimpleConnectionFactory(Map<String, Class<?>> typeMapping) {
        this.typeMapping = typeMapping;
    }

    @Override
    protected Connection doCreateConnection(DataSource dataSource) {
        Connection connection;
        try {
            connection = dataSource.getConnection();
            if (this.typeMapping != null && !this.typeMapping.isEmpty()) {
                connection.setTypeMap(this.typeMapping);
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new ConnectionCreationException(e, CredentialsMaskUtil.maskUrlUserAndPassword((String)e.getMessage(), (Pattern)CredentialsMaskUtil.PASSWORD_PATTERN_NO_QUOTES, (Pattern)CredentialsMaskUtil.USER_PATTERN_NO_QUOTES));
            }
            throw new ConnectionCreationException(e);
        }
        return connection;
    }
}

