/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.QueryExecutor;
import org.mule.module.db.internal.domain.executor.QueryExecutorFactory;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredProcedureMessageProcessor
extends AbstractSingleQueryDbMessageProcessor {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final QueryExecutorFactory queryExecutorFactory;
    private final boolean streaming;
    private final List<QueryType> queryTypes;
    private AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;

    public StoredProcedureMessageProcessor(DbConfigResolver dbConfigResolver, QueryResolver queryResolver, QueryExecutorFactory queryExecutorFactory, TransactionalAction transactionalAction, boolean streaming) {
        super(dbConfigResolver, queryResolver, transactionalAction);
        this.queryExecutorFactory = queryExecutorFactory;
        this.streaming = streaming;
        this.queryTypes = Collections.singletonList(QueryType.STORE_PROCEDURE_CALL);
        this.autoGeneratedKeyStrategy = new NoAutoGeneratedKeyStrategy();
    }

    @Override
    protected boolean mustCloseConnection() {
        return !this.streaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doExecuteQuery(DbConnection connection, Query query) throws SQLException {
        QueryExecutor queryExecutor = this.queryExecutorFactory.create();
        try {
            Object object = queryExecutor.execute(connection, query, this.autoGeneratedKeyStrategy);
            return object;
        }
        finally {
            this.closeQueryParameters(query);
        }
    }

    private void closeQueryParameters(Query query) {
        List<QueryParamValue> paramValues = query.getParamValues();
        if (paramValues != null && !paramValues.isEmpty()) {
            for (QueryParamValue paramValue : paramValues) {
                this.closeIfPossible(paramValue);
            }
        }
    }

    private void closeIfPossible(QueryParamValue paramValue) {
        if (paramValue.getValue() instanceof Closeable) {
            try {
                ((Closeable)paramValue.getValue()).close();
            }
            catch (IOException e) {
                this.logger.warn("Could not close query param {} in the stored procedure", paramValue.getValue());
            }
        }
    }

    @Override
    protected List<QueryType> getValidQueryTypes() {
        return this.queryTypes;
    }

    public void setAutoGeneratedKeyStrategy(AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) {
        this.autoGeneratedKeyStrategy = autoGeneratedKeyStrategy;
    }
}

