/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnector;
import org.mule.transport.sftp.SftpUtil;
import org.mule.transport.sftp.notification.SftpNotifier;

public class SftpMessageDispatcher
extends AbstractMessageDispatcher {
    private SftpConnector connector;
    private SftpUtil sftpUtil = null;

    public SftpMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (SftpConnector)endpoint.getConnector();
        this.sftpUtil = new SftpUtil((ImmutableEndpoint)endpoint);
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        InputStream inputStream;
        block21: {
            String filename = this.buildFilename(event);
            inputStream = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Writing file to: " + this.endpoint.getEndpointURI() + " [" + filename + "]"));
            }
            SftpClient client = null;
            boolean useTempDir = false;
            String transferFilename = null;
            try {
                String serviceName = event.getFlowConstruct() == null ? "UNKNOWN SERVICE" : event.getFlowConstruct().getName();
                SftpNotifier notifier = new SftpNotifier(this.connector, event.getMessage(), this.endpoint, serviceName);
                client = this.connector.createSftpClient(this.endpoint, notifier);
                String destDir = this.endpoint.getEndpointURI().getPath();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Connection setup successful, writing file.");
                }
                transferFilename = filename = client.duplicateHandling(destDir, filename, this.sftpUtil.getDuplicateHandling());
                boolean appendMode = this.sftpUtil.getDuplicateHandling().equals("append");
                useTempDir = this.sftpUtil.isUseTempDirOutbound();
                if (useTempDir) {
                    if (appendMode) {
                        this.logger.warn((Object)"Using file append mode to write, tempDirOutbound will be ignored as it is not supported on this mode.");
                    } else {
                        this.sftpUtil.cwdToTempDirOnOutbound(client, destDir);
                        boolean addUniqueSuffix = this.sftpUtil.isUseTempFileTimestampSuffix();
                        if (addUniqueSuffix) {
                            transferFilename = this.sftpUtil.createUniqueSuffix(transferFilename);
                        }
                    }
                }
                if (appendMode) {
                    if (event.getMessage().getPayload() instanceof OutputHandler) {
                        client.storeFile(transferFilename, event, (OutputHandler)event.getMessage().getPayload(), SftpClient.WriteMode.APPEND);
                    } else {
                        inputStream = this.generateInputStream(event);
                        client.storeFile(transferFilename, inputStream, SftpClient.WriteMode.APPEND);
                    }
                } else if (event.getMessage().getPayload() instanceof OutputHandler) {
                    client.storeFile(transferFilename, event, (OutputHandler)event.getMessage().getPayload());
                } else {
                    inputStream = this.generateInputStream(event);
                    client.storeFile(transferFilename, inputStream);
                }
                if (useTempDir && !appendMode) {
                    client.rename(transferFilename, destDir + "/" + filename);
                }
                this.logger.info((Object)("Successfully wrote file '" + filename + "' to " + this.endpoint.getEndpointURI()));
                if (client == null) break block21;
            }
            catch (Exception e) {
                try {
                    this.logger.error((Object)("Unexpected exception attempting to write file, message was: " + e.getMessage()), (Throwable)e);
                    this.sftpUtil.setErrorOccurredOnInputStream(inputStream);
                    if (useTempDir) {
                        String tempDir = this.sftpUtil.getTempDirOutbound();
                        this.sftpUtil.cleanupTempDir(client, transferFilename, tempDir);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        this.connector.releaseClient(this.endpoint, client);
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
            }
            this.connector.releaseClient(this.endpoint, client);
        }
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private InputStream generateInputStream(MuleEvent event) {
        InputStream inputStream;
        Object data = event.getMessage().getPayload();
        if (data instanceof byte[]) {
            byte[] buf = (byte[])data;
            inputStream = new ByteArrayInputStream(buf);
        } else if (data instanceof InputStream) {
            inputStream = (InputStream)data;
        } else if (data instanceof String) {
            inputStream = this.endpoint.getEncoding() == null ? new ByteArrayInputStream(((String)data).getBytes()) : new ByteArrayInputStream(((String)data).getBytes(Charset.forName(this.endpoint.getEncoding())));
        } else {
            throw new IllegalArgumentException("Unexpected message type: java.io.InputStream, byte[], or String expected. Got " + data.getClass().getName());
        }
        return inputStream;
    }

    private String buildFilename(MuleEvent event) {
        String filename;
        MuleMessage muleMessage = event.getMessage();
        String outPattern = (String)this.endpoint.getProperty((Object)"outputPattern");
        if (outPattern == null) {
            outPattern = (String)muleMessage.getProperty("outputPattern", (Object)this.connector.getOutputPattern());
        }
        if ((filename = this.connector.getFilenameParser().getFilename(muleMessage, outPattern)) == null) {
            filename = (String)event.getMessage().findPropertyInAnyScope("filename", null);
        }
        return filename;
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.getEndpoint().getMuleContext());
    }
}

