/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import java.util.List;
import java.util.regex.Matcher;
import org.mule.api.MuleEvent;
import org.mule.module.http.internal.HttpMessageBuilder;
import org.mule.module.http.internal.HttpParamType;
import org.mule.module.http.internal.ParameterMap;

public class HttpRequesterRequestBuilder
extends HttpMessageBuilder {
    public ParameterMap getQueryParams(MuleEvent event) {
        return this.resolveParams(event, HttpParamType.QUERY_PARAM);
    }

    public ParameterMap getHeaders(MuleEvent event) {
        return this.resolveParams(event, HttpParamType.HEADER);
    }

    public String replaceUriParams(String path, MuleEvent event) {
        ParameterMap uriParamMap = this.resolveParams(event, HttpParamType.URI_PARAM);
        for (String uriParamName : uriParamMap.keySet()) {
            List<String> uriParamValues = uriParamMap.getAll(uriParamName);
            String uriParamValue = uriParamValues.get(uriParamValues.size() - 1);
            if (uriParamValue == null) {
                throw new NullPointerException(String.format("Expression {%s} evaluated to null.", uriParamName));
            }
            path = path.replaceAll(String.format("\\{%s\\}", uriParamName), Matcher.quoteReplacement(uriParamValue));
        }
        return path;
    }
}

