/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.AnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.NonBlockingMessageProcessor;
import org.mule.processor.chain.DynamicMessageProcessorContainer;
import org.mule.util.NotificationUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowRefFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean<MessageProcessor>,
ApplicationContextAware,
MuleContextAware,
Initialisable,
Disposable {
    private static final String NULL_FLOW_CONTRUCT_NAME = "null";
    private static final String MULE_PREFIX = "_mule-";
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;
    private MessageProcessor referencedMessageProcessor;
    private ConcurrentMap<String, MessageProcessor> referenceCache = new ConcurrentHashMap<String, MessageProcessor>();

    public void setName(String name) {
        this.refName = name;
    }

    public void initialise() throws InitialisationException {
        if (this.refName.isEmpty()) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"flow reference is empty"), (Initialisable)this);
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.refName)) {
            this.referencedMessageProcessor = this.lookupReferencedFlowInApplicationContext(this.refName);
        }
    }

    public void dispose() {
        for (MessageProcessor processor : this.referenceCache.values()) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)processor).dispose();
        }
        this.referenceCache = null;
    }

    public MessageProcessor getObject() throws Exception {
        if (this.referencedMessageProcessor != null) {
            return this.referencedMessageProcessor;
        }
        return this.createDynamicReferenceMessageProcessor(this.refName);
    }

    protected MessageProcessor createDynamicReferenceMessageProcessor(String name) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (!this.referenceCache.containsKey(name)) {
            FlowRefMessageProcessorContainer dynamicReference = new FlowRefMessageProcessorContainer(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    String flowName = FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event);
                    final MessageProcessor dynamicMessageProcessor = FlowRefFactoryBean.this.getReferencedFlow(flowName, event.getFlowConstruct());
                    this.setResolvedMessageProcessor(dynamicMessageProcessor);
                    return new NonBlockingMessageProcessor(){

                        public MuleEvent process(MuleEvent event) throws MuleException {
                            return dynamicMessageProcessor.process(event);
                        }
                    }.process(event);
                }
            };
            if (dynamicReference instanceof Initialisable) {
                ((Initialisable)dynamicReference).initialise();
            }
            this.referenceCache.putIfAbsent(name, (MessageProcessor)dynamicReference);
        }
        return (MessageProcessor)this.referenceCache.get(name);
    }

    protected MessageProcessor getReferencedFlow(String name, FlowConstruct flowConstruct) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        String categorizedName = this.getReferencedFlowCategorizedName(name, flowConstruct);
        if (!this.referenceCache.containsKey(categorizedName)) {
            MessageProcessor referencedFlow = this.lookupReferencedFlowInApplicationContext(name);
            if (referencedFlow instanceof Initialisable) {
                if (referencedFlow instanceof FlowConstructAware) {
                    ((FlowConstructAware)referencedFlow).setFlowConstruct(flowConstruct);
                }
                if (referencedFlow instanceof MuleContextAware) {
                    ((MuleContextAware)referencedFlow).setMuleContext(this.muleContext);
                }
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (MessageProcessor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        if (processor instanceof FlowConstructAware) {
                            ((FlowConstructAware)processor).setFlowConstruct(flowConstruct);
                        }
                        if (!(processor instanceof MuleContextAware)) continue;
                        ((MuleContextAware)processor).setMuleContext(this.muleContext);
                    }
                }
                ((Initialisable)referencedFlow).initialise();
            }
            if (referencedFlow instanceof Startable) {
                ((Startable)referencedFlow).start();
            }
            this.referenceCache.putIfAbsent(categorizedName, referencedFlow);
        }
        return (MessageProcessor)this.referenceCache.get(categorizedName);
    }

    private String getReferencedFlowCategorizedName(String referencedFlowName, FlowConstruct flowConstruct) {
        String flowConstructName = flowConstruct != null ? flowConstruct.getName() : NULL_FLOW_CONTRUCT_NAME;
        return MULE_PREFIX + flowConstructName + "-" + referencedFlowName;
    }

    protected MessageProcessor lookupReferencedFlowInApplicationContext(String name) {
        final MessageProcessor referencedFlow = (MessageProcessor)this.applicationContext.getBean(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull((String)name));
        }
        if (referencedFlow instanceof FlowConstruct) {
            return new FlowRefMessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    return referencedFlow.process(event);
                }
            };
        }
        if (referencedFlow instanceof AnnotatedObject) {
            ((AnnotatedObject)referencedFlow).setAnnotations(this.getAnnotations());
        }
        return referencedFlow;
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?> getObjectType() {
        return MessageProcessor.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private abstract class FlowRefMessageProcessorContainer
    extends FlowRefMessageProcessor
    implements DynamicMessageProcessorContainer {
        private MessageProcessorPathElement pathElement;
        private MessageProcessor dynamicMessageProcessor;
        private Set<MessageProcessorContainer> processedDynamicMessageProcessors;

        private FlowRefMessageProcessorContainer() {
            this.processedDynamicMessageProcessors = new HashSet<MessageProcessorContainer>();
        }

        public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
            this.pathElement = pathElement;
        }

        public NotificationUtils.FlowMap buildInnerPaths() {
            if (this.dynamicMessageProcessor instanceof MessageProcessorContainer) {
                return this.buildInnerPaths((MessageProcessorContainer)this.dynamicMessageProcessor);
            }
            return null;
        }

        private NotificationUtils.FlowMap buildInnerPaths(MessageProcessorContainer messageProcessorContainer) {
            if (!this.processedDynamicMessageProcessors.contains(messageProcessorContainer)) {
                messageProcessorContainer.addMessageProcessorPathElements(this.getPathElement());
                this.processedDynamicMessageProcessors.add(messageProcessorContainer);
            }
            return NotificationUtils.buildPathResolver((MessageProcessorPathElement)this.getPathElement());
        }

        public MessageProcessorPathElement getPathElement() {
            return this.pathElement;
        }

        protected void setResolvedMessageProcessor(MessageProcessor dynamicMessageProcessor) {
            this.dynamicMessageProcessor = dynamicMessageProcessor;
        }
    }

    private abstract class FlowRefMessageProcessor
    implements NonBlockingMessageProcessor,
    AnnotatedObject {
        private FlowRefMessageProcessor() {
        }

        public Object getAnnotation(QName name) {
            return FlowRefFactoryBean.this.getAnnotation(name);
        }

        public Map<QName, Object> getAnnotations() {
            return FlowRefFactoryBean.this.getAnnotations();
        }

        public void setAnnotations(Map<QName, Object> annotations) {
            FlowRefFactoryBean.this.setAnnotations(annotations);
        }
    }
}

