/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.loader;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ClassPathResourceLoader;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

public class ExchangeDependencyResourceLoader
implements ResourceLoader {
    private static final String BASE_PATH = ".";
    private final File workingDir;
    private final ResourceLoader resourceLoader;
    private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

    public ExchangeDependencyResourceLoader() {
        this(BASE_PATH);
    }

    public ExchangeDependencyResourceLoader(String path) {
        this.workingDir = new File(path);
        this.resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new FileResourceLoader(path), new ClassPathResourceLoader()});
    }

    @Nullable
    public InputStream fetchResource(String path) {
        int dependencyIndex;
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
        String resourceName = matcher.find() ? ((dependencyIndex = path.lastIndexOf(matcher.group(0))) <= 0 ? path : path.substring(dependencyIndex)) : path;
        return this.resourceLoader.fetchResource(new File(this.workingDir, resourceName).getPath());
    }
}

