/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv2.v10.model;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.raml.implv2.v10.model.ParameterImpl;
import org.mule.raml.implv2.v10.model.RamlImpl10V2;
import org.mule.raml.interfaces.model.IMimeType;
import org.mule.raml.interfaces.model.parameter.IParameter;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class MimeTypeImpl
implements IMimeType {
    private TypeDeclaration typeDeclaration;
    private Optional<String> typeAsString;

    public MimeTypeImpl(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
    }

    public String getType() {
        return this.typeDeclaration.name();
    }

    public String getExample() {
        ExampleSpec example = MimeTypeImpl.getExample(this.typeDeclaration);
        return example != null ? example.value() : null;
    }

    private static ExampleSpec getExample(TypeDeclaration typeDeclaration) {
        ExampleSpec localExample = MimeTypeImpl.getExampleFromLocal(typeDeclaration);
        if (localExample != null) {
            return localExample;
        }
        if (typeDeclaration instanceof ObjectTypeDeclaration) {
            return MimeTypeImpl.getExampleFromParent((ObjectTypeDeclaration)typeDeclaration);
        }
        if (typeDeclaration instanceof UnionTypeDeclaration) {
            List parentTypes = ((UnionTypeDeclaration)typeDeclaration).of();
            for (TypeDeclaration parentType : parentTypes) {
                ExampleSpec example = MimeTypeImpl.getExample(parentType);
                if (example == null) continue;
                return example;
            }
        }
        return null;
    }

    private static ExampleSpec getExampleFromLocal(TypeDeclaration typeDeclaration) {
        ExampleSpec example = typeDeclaration.example();
        if (example != null && example.value() != null) {
            return example;
        }
        List examples = typeDeclaration.examples();
        if (examples != null && !examples.isEmpty()) {
            for (ExampleSpec e : examples) {
                if (e.value() == null) continue;
                return e;
            }
        }
        return null;
    }

    private static ExampleSpec getExampleFromParent(ObjectTypeDeclaration typeDeclaration) {
        if (!MimeTypeImpl.hasLocalProperties(typeDeclaration)) {
            for (TypeDeclaration declaration : typeDeclaration.parentTypes()) {
                ExampleSpec parentExample = MimeTypeImpl.getExample(declaration);
                if (parentExample == null) continue;
                return parentExample;
            }
        }
        return null;
    }

    private static boolean hasLocalProperties(ObjectTypeDeclaration typeDeclaration) {
        List parentTypes = typeDeclaration.parentTypes();
        if (parentTypes.isEmpty()) {
            return true;
        }
        int propertiesCount = typeDeclaration.properties().size();
        for (TypeDeclaration parentType : parentTypes) {
            if (!(parentType instanceof ObjectTypeDeclaration) || ((ObjectTypeDeclaration)parentType).properties().size() >= propertiesCount) continue;
            return true;
        }
        return false;
    }

    public String getSchema() {
        if (this.typeAsString == null) {
            this.typeAsString = Optional.fromNullable((Object)RamlImpl10V2.getTypeAsString(this.typeDeclaration));
        }
        return (String)this.typeAsString.orNull();
    }

    public Map<String, List<IParameter>> getFormParameters() {
        LinkedHashMap<String, List<IParameter>> result = new LinkedHashMap<String, List<IParameter>>();
        if (this.typeDeclaration instanceof ObjectTypeDeclaration) {
            List parameters = ((ObjectTypeDeclaration)this.typeDeclaration).properties();
            for (TypeDeclaration parameter : parameters) {
                ArrayList<ParameterImpl> list = new ArrayList<ParameterImpl>();
                list.add(new ParameterImpl(parameter));
                result.put(parameter.name(), list);
            }
        }
        return result;
    }

    public List<ValidationResult> validate(String payload) {
        return this.typeDeclaration.validate(payload);
    }

    public Object getCompiledSchema() {
        throw new UnsupportedOperationException();
    }

    public Object getInstance() {
        throw new UnsupportedOperationException();
    }
}

