/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType itemType;
    private int cardinality;
    private RoleDiagnostic role;
    private Location locator;
    private int count = 0;
    private int level = 0;
    private HashSet<Long> checkedElements = new HashSet(10);

    public TypeCheckingFilter(Receiver next) {
        super(next);
    }

    public void setRequiredType(ItemType type, int cardinality, RoleDiagnostic role, Location locator) {
        this.itemType = type;
        this.cardinality = cardinality;
        this.role = role;
        this.locator = locator;
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            CombinedNodeTest type = new CombinedNodeTest(new NameTest(2, nameCode, this.getNamePool()), 23, new ContentTypeTest(2, typeCode, this.getConfiguration(), false));
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.TEXT;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.COMMENT;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(ExplicitLocation.UNKNOWN_LOCATION);
            }
            NodeKindTest type = NodeKindTest.NAMESPACE;
            this.checkItemType(type, ExplicitLocation.UNKNOWN_LOCATION);
        }
        this.nextReceiver.namespace(namespaceBinding, properties);
    }

    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.PROCESSING_INSTRUCTION;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    public void startDocument(int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(ExplicitLocation.UNKNOWN_LOCATION);
            }
            NodeKindTest type = NodeKindTest.DOCUMENT;
            this.checkItemType(type, ExplicitLocation.UNKNOWN_LOCATION);
        }
        ++this.level;
        this.nextReceiver.startDocument(properties);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 1) {
                CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nameCode, this.getNamePool()), 23, new ContentTypeTest(1, typeCode, this.getConfiguration(), false));
                this.checkItemType(type, location);
            } else {
                long key;
                if (this.count == 2) {
                    this.checkAllowsMany(location);
                }
                if (!this.checkedElements.contains(key = (long)(nameCode.allocateNameCode(this.getNamePool()) & 0xFFFFF) << 32 | (long)typeCode.getFingerprint())) {
                    CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nameCode, this.getNamePool()), 23, new ContentTypeTest(1, typeCode, this.getConfiguration(), false));
                    this.checkItemType(type, location);
                    this.checkedElements.add(key);
                }
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }

    public void endDocument() throws XPathException {
        --this.level;
        this.nextReceiver.endDocument();
    }

    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            throw err;
        }
    }

    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItemType(Type.getItemType(item, this.getConfiguration().getTypeHierarchy()), locationId);
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        } else {
            super.append(item, locationId, copyNamespaces);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    private void checkItemType(ItemType type, Location locationId) throws XPathException {
        if (!this.getConfiguration().getTypeHierarchy().isSubType(type, this.itemType)) {
            String message = this.role.composeErrorMessage(this.itemType, type);
            String errorCode = this.role.getErrorCode();
            XPathException err = new XPathException(message);
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == null) {
                err.setLocation(this.locator);
            } else {
                err.setLocation(locationId.saveLocation());
            }
            throw err;
        }
    }

    private void checkAllowsMany(Location locationId) throws XPathException {
        if (!Cardinality.allowsMany(this.cardinality)) {
            XPathException err = new XPathException("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == null || locationId == ExplicitLocation.UNKNOWN_LOCATION) {
                err.setLocator(this.locator);
            } else {
                err.setLocator(locationId);
            }
            throw err;
        }
    }
}

