/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.apache.commons.collections.Factory;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.RefreshTokenManager;
import org.mule.util.store.ProvidedObjectStoreWrapper;

public class DefaultRefreshTokenManager
implements MuleContextAware,
RefreshTokenManager {
    private volatile ObjectStore<Boolean> refreshedTokens;
    private MuleContext muleContext;
    private int minRefreshInterval = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshToken(OAuth2Adapter adapter, String accessTokenId) throws Exception {
        if (StringUtils.isEmpty((String)accessTokenId)) {
            throw new IllegalArgumentException("Cannot refresh a blank accessTokenId");
        }
        String id = String.format("%s:%s:%s", this.getClass().getCanonicalName(), adapter.getName(), accessTokenId);
        Lock lock = this.muleContext.getLockFactory().createLock(id);
        lock.lock();
        try {
            if (!this.getRefreshedTokens().contains((Serializable)((Object)id))) {
                adapter.refreshAccessToken(accessTokenId);
                this.getRefreshedTokens().store((Serializable)((Object)id), (Serializable)Boolean.valueOf(true));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private synchronized ObjectStore<Boolean> getRefreshedTokens() {
        if (this.refreshedTokens == null) {
            this.refreshedTokens = new ProvidedObjectStoreWrapper(null, this.internalObjectStoreFactory());
        }
        return this.refreshedTokens;
    }

    protected Factory internalObjectStoreFactory() {
        return new Factory(){

            public Object create() {
                ObjectStoreManager osManager = DefaultRefreshTokenManager.this.muleContext.getObjectStoreManager();
                return osManager.getObjectStore("RefreshTokenStore", false, 0, DefaultRefreshTokenManager.this.minRefreshInterval, DefaultRefreshTokenManager.this.minRefreshInterval);
            }
        };
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setMinRefreshIntervalInMillis(int minRefreshIntervalInMillis) {
        this.minRefreshInterval = minRefreshIntervalInMillis;
    }

    @Override
    public synchronized void setRefreshedTokensStore(ObjectStore<Boolean> refreshedTokens) throws IllegalStateException {
        if (this.refreshedTokens != null) {
            throw new IllegalStateException("refreshedTokens object store had already been set/obtained for this DefaultRefreshTokenManager: " + this.toString());
        }
        this.refreshedTokens = new ProvidedObjectStoreWrapper(refreshedTokens, this.internalObjectStoreFactory());
    }
}

