/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.common.security.oauth.AuthorizationParameter;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.processor.AbstractAuthorizeMessageProcessor;
import org.mule.security.oauth.processor.OAuth2FetchAccessTokenMessageProcessor;
import org.mule.utils.IdUtils;

public abstract class BaseOAuth2AuthorizeMessageProcessor<T extends OAuth2Manager<OAuth2Adapter>>
extends AbstractAuthorizeMessageProcessor {
    protected abstract Class<T> getOAuthManagerClass();

    @Override
    public final void start() throws MuleException {
        super.start();
        OAuth2Manager<OAuth2Adapter> module = this.getOAuthManager();
        String accessTokenId = this.getAccessTokenId();
        if (StringUtils.isEmpty((String)accessTokenId) && StringUtils.isEmpty((String)(accessTokenId = module.getDefaultAccessTokenId()))) {
            accessTokenId = module.getDefaultUnauthorizedConnector().getName();
        }
        OAuth2FetchAccessTokenMessageProcessor fetchAccessTokenMessageProcessor = new OAuth2FetchAccessTokenMessageProcessor(module, accessTokenId);
        this.startCallback(module, fetchAccessTokenMessageProcessor);
        if (this.getAccessTokenUrl() != null) {
            fetchAccessTokenMessageProcessor.setAccessTokenUrl(this.getAccessTokenUrl());
        } else {
            fetchAccessTokenMessageProcessor.setAccessTokenUrl(module.getDefaultUnauthorizedConnector().getAccessTokenUrl());
        }
    }

    @Override
    protected final MuleEvent doProcess(MuleEvent event) throws Exception {
        OAuth2Manager<OAuth2Adapter> moduleObject = this.getOAuthManager();
        String transformedAuthorizationUrl = this.toString(event, this.getAuthorizationUrl());
        String transformedAccessTokenUrl = this.toString(event, this.getAccessTokenUrl());
        event.setFlowVariable("_OAUTH_AUTHORIZATION_URL", (Object)transformedAuthorizationUrl);
        event.setFlowVariable("_OAUTH_ACCESS_TOKEN_URL", (Object)transformedAccessTokenUrl);
        String location = moduleObject.buildAuthorizeUrl(this.getExtraParameters(event, moduleObject), transformedAuthorizationUrl, this.getOauthCallback().getUrl());
        MuleMessage message = event.getMessage();
        moduleObject.storeAuthorizationEvent(event);
        this.notifyAuthorizeStart(event);
        message.setOutboundProperty("http.status", (Object)"302");
        message.setOutboundProperty("Location", (Object)location);
        return event;
    }

    private void setState(Map<String, String> extraParameters, MuleEvent event) {
        String state = IdUtils.padId(event.getId());
        if (this.getState() != null) {
            state = state + this.toString(event, this.getState());
        }
        extraParameters.put("state", state);
    }

    private Map<String, String> getExtraParameters(MuleEvent event, OAuth2Manager<OAuth2Adapter> moduleObject) throws MessagingException, TransformerException {
        Set<AuthorizationParameter<?>> params = moduleObject.getDefaultUnauthorizedConnector().getAuthorizationParameters();
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        this.setState(extraParameters, event);
        if (params != null) {
            for (AuthorizationParameter<?> parameter : params) {
                Field field = null;
                try {
                    field = this.getClass().getDeclaredField(parameter.getName());
                }
                catch (NoSuchFieldException e) {
                    throw new MessagingException(CoreMessages.createStaticMessage((String)String.format("Code generation error. Field %s should be present in class", parameter.getName())), event, (Throwable)e, (MessageProcessor)this);
                }
                field.setAccessible(true);
                try {
                    Object value = field.get(this);
                    if (value == null) continue;
                    Object transformed = this.evaluateAndTransform(this.getMuleContext(), event, (Type)parameter.getType(), null, value);
                    extraParameters.put(parameter.getName(), this.toString(event, transformed).toLowerCase());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return extraParameters;
    }

    protected OAuth2Manager<OAuth2Adapter> getOAuthManager() {
        try {
            Object maybeAManager = this.findOrCreate(this.getOAuthManagerClass(), false, null);
            if (!(maybeAManager instanceof OAuth2Manager)) {
                throw new IllegalStateException(String.format("Object of class %s does not implement OAuth2Manager", this.getOAuthManagerClass().getCanonicalName()));
            }
            return (OAuth2Manager)maybeAManager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

