/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.validation;

import com.fasterxml.jackson.core.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.json.validation.JsonSchemaDereferencing;
import org.mule.module.json.validation.JsonSchemaValidator;

public class ValidateJsonSchemaMessageProcessor
implements MessageProcessor,
Initialisable {
    public static String ALLOW_DUPLICATE_KEYS_SYSTEM_PROPERTY = "mule.json.validator.allowDuplicateKeys";
    private boolean allowDuplicateKeys = Boolean.parseBoolean(System.getProperty(ALLOW_DUPLICATE_KEYS_SYSTEM_PROPERTY, "true"));
    private String schemaLocation;
    private JsonSchemaDereferencing dereferencing = JsonSchemaDereferencing.CANONICAL;
    private Map<String, String> schemaRedirects = new HashMap<String, String>();
    private JsonSchemaValidator validator;

    public void initialise() throws InitialisationException {
        ArrayList<JsonParser.Feature> features = new ArrayList<JsonParser.Feature>();
        if (!this.allowDuplicateKeys) {
            features.add(JsonParser.Feature.STRICT_DUPLICATE_DETECTION);
        }
        this.validator = JsonSchemaValidator.builder().setSchemaLocation(this.schemaLocation).setDereferencing(this.dereferencing).addSchemaRedirects(this.schemaRedirects).addFeatures(features).build();
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        this.validator.validate(event);
        return event;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setDereferencing(JsonSchemaDereferencing dereferencing) {
        this.dereferencing = dereferencing;
    }

    public void setSchemaRedirects(Map<String, String> schemaRedirects) {
        this.schemaRedirects = schemaRedirects;
    }
}

