/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataPropertyManager;
import org.mule.common.metadata.TypeMetaDataModel;
import org.mule.common.metadata.key.property.MetaDataKeyProperty;
import org.mule.common.metadata.key.property.dsql.DsqlFromMetaDataKeyProperty;

public class DefaultMetaDataKey
implements MetaDataKey,
TypeMetaDataModel {
    private static final String DEFAULT_CATEGORY = "DEFAULT";
    private String id;
    private String displayName;
    private String category;
    private MetaDataPropertyManager<MetaDataKeyProperty> metaDataKeyPropertiesManager;

    public DefaultMetaDataKey(String id, String displayName) {
        this(id, displayName, new ArrayList<MetaDataKeyProperty>());
        this.metaDataKeyPropertiesManager.addProperty(new DsqlFromMetaDataKeyProperty());
    }

    public DefaultMetaDataKey(String id, String displayName, List<MetaDataKeyProperty> keyProperties) {
        this.id = id;
        this.displayName = displayName;
        this.category = DEFAULT_CATEGORY;
        this.metaDataKeyPropertiesManager = new MetaDataPropertyManager<MetaDataKeyProperty>(keyProperties);
    }

    @Deprecated
    public DefaultMetaDataKey(String id, String displayName, boolean isFromCapable) {
        this.id = id;
        this.displayName = displayName;
        this.category = DEFAULT_CATEGORY;
        this.metaDataKeyPropertiesManager = new MetaDataPropertyManager();
        if (isFromCapable) {
            this.metaDataKeyPropertiesManager.addProperty(new DsqlFromMetaDataKeyProperty());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public List<MetaDataKeyProperty> getProperties() {
        return this.metaDataKeyPropertiesManager.getProperties();
    }

    @Override
    public boolean addProperty(MetaDataKeyProperty metaDataKeyProperty) {
        return this.metaDataKeyPropertiesManager.addProperty(metaDataKeyProperty);
    }

    @Override
    public boolean removeProperty(MetaDataKeyProperty metaDataKeyProperty) {
        return this.metaDataKeyPropertiesManager.removeProperty(metaDataKeyProperty);
    }

    @Override
    public boolean hasProperty(Class<? extends MetaDataKeyProperty> metaDataKeyProperty) {
        return this.metaDataKeyPropertiesManager.hasProperty(metaDataKeyProperty);
    }

    @Override
    public <T extends MetaDataKeyProperty> T getProperty(Class<T> metaDataKeyProperty) {
        return (T)((MetaDataKeyProperty)this.metaDataKeyPropertiesManager.getProperty(metaDataKeyProperty));
    }

    public String toString() {
        return "DefaultMetaDataKey:{ displayName:" + this.displayName + " id:" + this.id + " category:" + this.category + " }";
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultMetaDataKey)) {
            return false;
        }
        DefaultMetaDataKey that = (DefaultMetaDataKey)obj;
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    @Override
    public int compareTo(MetaDataKey otherMetadataKey) {
        int res = this.category.compareTo(otherMetadataKey.getCategory());
        if (res != 0) {
            return res;
        }
        return this.id.compareTo(otherMetadataKey.getId());
    }

    @Override
    @Deprecated
    public boolean isFromCapable() {
        return this.metaDataKeyPropertiesManager.hasProperty(DsqlFromMetaDataKeyProperty.class);
    }
}

