/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.mule.module.db.internal.domain.connection.AbstractDbConnection;
import org.mule.module.db.internal.domain.connection.DefaultDbConnectionReleaser;
import org.mule.module.db.internal.domain.connection.type.resolver.CollectionTypeResolver;
import org.mule.module.db.internal.domain.connection.type.resolver.StructTypeResolver;
import org.mule.module.db.internal.domain.connection.type.resolver.TypeResolver;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.resolver.param.ParamTypeResolverFactory;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDbConnection
extends AbstractDbConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final int UNKNOWN_DATA_TYPE = -1;
    public static final int DATA_TYPE_INDEX = 5;
    public static final int ATTR_TYPE_NAME_INDEX = 6;
    private static final List<String> LOB_TYPES = Arrays.asList(JdbcTypes.BLOB_DB_TYPE.getName(), JdbcTypes.CLOB_DB_TYPE.getName());

    public DefaultDbConnection(Connection delegate, TransactionalAction transactionalAction, DefaultDbConnectionReleaser connectionReleaseListener, ParamTypeResolverFactory paramTypeResolverFactory) {
        super(delegate, transactionalAction, connectionReleaseListener, paramTypeResolverFactory);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.delegate.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.delegate.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.delegate.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> stringClassMap) throws SQLException {
        this.delegate.setTypeMap(stringClassMap);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.delegate.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.resolveLobs(typeName, elements, new CollectionTypeResolver(this));
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.resolveLobs(typeName, attributes, new StructTypeResolver(this));
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    @Override
    protected void resolveLobs(String typeName, Object[] attributes, TypeResolver typeResolver) throws SQLException {
        try {
            Map<Integer, ResolvedDbType> dataTypes = this.getLobFieldsDataTypeInfo(typeName);
            for (Map.Entry<Integer, ResolvedDbType> entry : dataTypes.entrySet()) {
                Integer key = entry.getKey();
                ResolvedDbType dataType = entry.getValue();
                typeResolver.resolveLobIn(attributes, key, dataType);
            }
        }
        catch (SQLException e) {
            this.logger.warn("Unable to resolve lobs: {}. Proceeding with original attributes.", (Object)e.getMessage());
        }
    }

    protected Map<Integer, ResolvedDbType> getLobFieldsDataTypeInfo(String typeName) throws SQLException {
        HashMap<Integer, ResolvedDbType> dataTypes = new HashMap<Integer, ResolvedDbType>();
        try (ResultSet resultSet = this.getMetaData().getAttributes(this.getCatalog(), null, typeName, null);){
            int index = 0;
            while (resultSet.next()) {
                int dataType = resultSet.getInt(5);
                String dataTypeName = resultSet.getString(6);
                if (LOB_TYPES.contains(dataTypeName)) {
                    dataTypes.put(index, new ResolvedDbType(dataType, dataTypeName));
                }
                ++index;
            }
        }
        return dataTypes;
    }

    public void doResolveLobIn(Object[] attributes, int index, int dataType, String dataTypeName) throws SQLException {
        if (this.shouldResolveAttributeWithJdbcType(dataType, dataTypeName, JdbcTypes.BLOB_DB_TYPE)) {
            attributes[index] = this.createBlob(attributes[index]);
        } else if (this.shouldResolveAttributeWithJdbcType(dataType, dataTypeName, JdbcTypes.CLOB_DB_TYPE)) {
            attributes[index] = this.createClob(attributes[index]);
        }
    }

    private boolean shouldResolveAttributeWithJdbcType(int dbDataType, String dbDataTypeName, DbType jdbcType) {
        if (dbDataType == -1) {
            return dbDataTypeName.equals(jdbcType.getName());
        }
        return dbDataType == jdbcType.getId();
    }

    public void doResolveLobIn(Object[] attributes, int index, String dataTypeName) throws SQLException {
        this.doResolveLobIn(attributes, index, -1, dataTypeName);
    }

    private Blob createBlob(Object attribute) throws SQLException {
        Blob blob = this.createBlob();
        if (attribute instanceof byte[]) {
            blob.setBytes(1L, (byte[])attribute);
        } else if (attribute instanceof InputStream) {
            blob.setBytes(1L, IOUtils.toByteArray((InputStream)((InputStream)attribute)));
        } else if (attribute instanceof String) {
            blob.setBytes(1L, ((String)attribute).getBytes());
        } else {
            throw new IllegalArgumentException(String.format("Cannot create a %s from a value of type '%s'", Struct.class.getName(), attribute.getClass()));
        }
        return blob;
    }

    private Clob createClob(Object attribute) throws SQLException {
        Clob clob = this.createClob();
        if (attribute instanceof String) {
            clob.setString(1L, (String)attribute);
        } else if (attribute instanceof InputStream) {
            clob.setString(1L, IOUtils.toString((InputStream)((InputStream)attribute)));
        } else {
            throw new IllegalArgumentException(String.format("Cannot create a %s from a value of type '%s'", Struct.class.getName(), attribute.getClass()));
        }
        return clob;
    }
}

