/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection.type.resolver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.mule.module.db.internal.domain.connection.DefaultDbConnection;
import org.mule.module.db.internal.domain.connection.oracle.OracleConnectionUtils;
import org.mule.module.db.internal.domain.connection.type.resolver.TypeResolver;
import org.mule.module.db.internal.domain.type.ResolvedDbType;

public class CollectionTypeResolver
implements TypeResolver {
    public static final String QUERY_ALL_COLL_TYPES = "SELECT * FROM SYS.ALL_COLL_TYPES WHERE TYPE_NAME = ?";
    private static final String ELEM_TYPE_NAME = "ELEM_TYPE_NAME";
    private DefaultDbConnection connection;

    public CollectionTypeResolver(DefaultDbConnection connection) {
        this.connection = connection;
    }

    @Override
    public void resolveLobs(Object[] elements, Integer index, String dataTypeName) throws SQLException {
        for (Object element : elements) {
            this.connection.doResolveLobIn((Object[])element, index, dataTypeName);
        }
    }

    @Override
    public String resolveType(String typeName) throws SQLException {
        String collectionTypeName = this.getTypeFor(typeName);
        if (collectionTypeName != null) {
            return collectionTypeName;
        }
        return typeName;
    }

    @Override
    public void resolveLobIn(Object[] attributes, Integer index, ResolvedDbType resolvedDbType) throws SQLException {
        for (Object attribute : attributes) {
            this.connection.doResolveLobIn((Object[])attribute, index, resolvedDbType.getId(), resolvedDbType.getName());
        }
    }

    private String getTypeFor(String collectionTypeName) throws SQLException {
        String dataType = null;
        String owner = OracleConnectionUtils.getOwnerFrom(collectionTypeName);
        String typeName = OracleConnectionUtils.getTypeSimpleName(collectionTypeName);
        String query = QUERY_ALL_COLL_TYPES;
        if (owner != null) {
            query = query + " AND OWNER = ?";
        }
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setString(1, typeName);
            if (owner != null) {
                ps.setString(2, owner);
            }
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    dataType = resultSet.getString(ELEM_TYPE_NAME);
                }
            }
        }
        return dataType;
    }
}

