/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.lang.reflect.Proxy;
import javax.transaction.TransactionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class TransactionManagerFactoryBean
implements FactoryBean<TransactionManager>,
MuleContextAware {
    static String WRONG_DEFINITION_ERROR = "It is not possible to define both TransactionManager and TransactionManagerFactory";
    @Autowired(required=false)
    private TransactionManagerFactory txManagerFactory;
    @Lazy
    @Autowired(required=false)
    private TransactionManager customTxManager;
    private MuleContext muleContext;

    public TransactionManager getObject() throws Exception {
        if (this.muleContext.isDisposing()) {
            return null;
        }
        if (this.txManagerFactory != null && this.customTxManager != null && !Proxy.isProxyClass(this.customTxManager.getClass())) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)WRONG_DEFINITION_ERROR));
        }
        if (this.txManagerFactory != null) {
            try {
                return this.txManagerFactory.create(this.muleContext.getConfiguration());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToCreate((String)"transaction manager"), (Throwable)e);
            }
        }
        return this.customTxManager;
    }

    public Class<?> getObjectType() {
        return TransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTxManagerFactory(TransactionManagerFactory txManagerFactory) {
        this.txManagerFactory = txManagerFactory;
    }

    public void setCustomTxManager(TransactionManager customTxManager) {
        this.customTxManager = customTxManager;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

