/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageLogger
extends HttpProbe.Adapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageLogger.class);
    private final LoggerType loggerType;

    public HttpMessageLogger(LoggerType loggerType) {
        this.loggerType = loggerType;
    }

    public void onDataReceivedEvent(Connection connection, Buffer buffer) {
        this.logBuffer(buffer, this.getClassLoader(connection));
    }

    public void onDataSentEvent(Connection connection, Buffer buffer) {
        this.logBuffer(buffer, this.getClassLoader(connection));
    }

    private void logBuffer(Buffer buffer, ClassLoader classLoader) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        boolean isClassLoaderNull = classLoader == null;
        try {
            if (!isClassLoaderNull) {
                this.setContextClassLoader(currentThread, originalClassLoader, classLoader);
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.loggerType.name() + "\n" + buffer.toStringContent());
            }
            if (!isClassLoaderNull) {
                this.setContextClassLoader(currentThread, classLoader, originalClassLoader);
            }
        }
        catch (Exception e) {
            if (!isClassLoaderNull) {
                this.setContextClassLoader(currentThread, classLoader, originalClassLoader);
            }
            throw e;
        }
    }

    private ClassLoader getClassLoader(Connection connection) {
        return connection.getAttributes() != null ? (ClassLoader)connection.getAttributes().getAttribute("MULE_CLASSLOADER") : null;
    }

    private void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
        if (currentClassLoader != newClassLoader && newClassLoader != null) {
            thread.setContextClassLoader(newClassLoader);
        }
    }

    public static enum LoggerType {
        LISTENER,
        REQUESTER;

    }
}

