/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.ExceptionHelper;
import org.mule.execution.AsyncResponseFlowProcessingPhaseTemplate;
import org.mule.execution.ResponseCompletionCallback;
import org.mule.execution.ThrottlingPhaseTemplate;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.HttpResponseBuilder;
import org.mule.module.http.internal.listener.HttpThrottlingHeadersMapBuilder;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageProcessorTemplate
implements AsyncResponseFlowProcessingPhaseTemplate,
ThrottlingPhaseTemplate {
    public static final int MESSAGE_DISCARD_STATUS_CODE = Integer.valueOf(System.getProperty("mule.transport.http.throttling.discardstatuscode", "429"));
    public static final String MESSAGE_DISCARD_MESSAGE_BODY = "API calls exceeded";
    public static final String MESSAGE_DISCARD_REASON_PHRASE = "Too Many Requests";
    public static final String X_RATE_LIMIT_LIMIT_HEADER = "X-RateLimit-Limit";
    public static final String X_RATE_LIMIT_REMAINING_HEADER = "X-RateLimit-Remaining";
    public static final String X_RATE_LIMIT_RESET_HEADER = "X-RateLimit-Reset";
    private static final int INTERNAL_SERVER_ERROR_STATUS_CODE = 500;
    private static final int OK_STATUS_CODE = 200;
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageProcessorTemplate.class);
    private MuleEvent sourceMuleEvent;
    private MessageProcessor messageProcessor;
    private HttpResponseReadyCallback responseReadyCallback;
    private HttpResponseBuilder responseBuilder;
    private HttpResponseBuilder errorResponseBuilder;
    private HttpThrottlingHeadersMapBuilder httpThrottlingHeadersMapBuilder = new HttpThrottlingHeadersMapBuilder();
    private Map<String, String> extraHeaders = new HashMap<String, String>();
    private final String httpVersion;

    public HttpMessageProcessorTemplate(MuleEvent sourceMuleEvent, MessageProcessor messageProcessor, HttpResponseReadyCallback responseReadyCallback, HttpResponseBuilder responseBuilder, HttpResponseBuilder errorResponseBuilder) {
        this.sourceMuleEvent = sourceMuleEvent;
        this.messageProcessor = messageProcessor;
        this.responseBuilder = responseBuilder;
        this.errorResponseBuilder = errorResponseBuilder;
        this.responseReadyCallback = responseReadyCallback;
        this.httpVersion = (String)sourceMuleEvent.getMessage().getInboundProperty("http.version");
    }

    public MuleEvent getMuleEvent() throws MuleException {
        return this.sourceMuleEvent;
    }

    public MuleEvent routeEvent(MuleEvent muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    public void afterFailureProcessingFlow(Exception exception) {
    }

    public void sendResponseToClient(MuleEvent muleEvent, ResponseCompletionCallback responseCompletationCallback) throws MuleException {
        org.mule.module.http.internal.domain.response.HttpResponseBuilder responseBuilder = new org.mule.module.http.internal.domain.response.HttpResponseBuilder();
        HttpResponse httpResponse = this.buildResponse(muleEvent, responseBuilder, responseCompletationCallback);
        this.responseReadyCallback.responseReady(httpResponse, this.getResponseFailureCallback(responseCompletationCallback, muleEvent));
    }

    protected HttpResponse buildErrorResponse() {
        org.mule.module.http.internal.domain.response.HttpResponseBuilder errorResponseBuilder = new org.mule.module.http.internal.domain.response.HttpResponseBuilder();
        HttpResponse errorResponse = errorResponseBuilder.setStatusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).setReasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).setEntity(new EmptyHttpEntity()).build();
        return errorResponse;
    }

    protected HttpResponse buildResponse(MuleEvent muleEvent, org.mule.module.http.internal.domain.response.HttpResponseBuilder responseBuilder, ResponseCompletionCallback responseCompletationCallback) {
        this.addThrottlingHeaders(responseBuilder);
        HttpResponse httpResponse = muleEvent == null ? responseBuilder.setStatusCode(200).build() : this.doBuildResponse(muleEvent, responseBuilder, responseCompletationCallback);
        return httpResponse;
    }

    protected HttpResponse doBuildResponse(MuleEvent muleEvent, org.mule.module.http.internal.domain.response.HttpResponseBuilder responseBuilder, ResponseCompletionCallback responseCompletationCallback) {
        try {
            return this.responseBuilder.build(responseBuilder, muleEvent, this.httpVersion);
        }
        catch (Exception e) {
            try {
                MuleEvent exceptionStrategyResult = responseCompletationCallback.responseSentWithFailure(e, muleEvent);
                return this.responseBuilder.build(responseBuilder, exceptionStrategyResult, null);
            }
            catch (Exception innerException) {
                return this.buildErrorResponse();
            }
        }
    }

    private ResponseStatusCallback getResponseFailureCallback(final ResponseCompletionCallback responseCompletationCallback, MuleEvent muleEvent) {
        return new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable throwable) {
                HttpMessageProcessorTemplate.this.responseReadyCallback.responseReady(HttpMessageProcessorTemplate.this.buildErrorResponse(), this);
            }

            @Override
            public void responseSendSuccessfully() {
                responseCompletationCallback.responseSentSuccessfully();
            }
        };
    }

    public void sendFailureResponseToClient(MessagingException messagingException, ResponseCompletionCallback responseCompletationCallback) throws MuleException {
        String exceptionStatusCode = ExceptionHelper.getTransportErrorMapping((String)HttpConstants.Protocols.HTTP.getScheme(), ((Object)((Object)messagingException)).getClass(), (MuleContext)this.sourceMuleEvent.getMuleContext());
        Integer statusCodeFromException = exceptionStatusCode != null ? Integer.valueOf(exceptionStatusCode) : 500;
        org.mule.module.http.internal.domain.response.HttpResponseBuilder failureResponseBuilder = new org.mule.module.http.internal.domain.response.HttpResponseBuilder().setStatusCode(statusCodeFromException).setReasonPhrase(messagingException.getMessage());
        this.addThrottlingHeaders(failureResponseBuilder);
        MuleEvent event = messagingException.getEvent();
        event.getMessage().setPayload((Object)messagingException.getMessage());
        HttpResponse response = this.errorResponseBuilder.build(failureResponseBuilder, event, null);
        this.responseReadyCallback.responseReady(response, this.getResponseFailureCallback(responseCompletationCallback, messagingException.getEvent()));
    }

    public void discardMessageOnThrottlingExceeded() throws MuleException {
        org.mule.module.http.internal.domain.response.HttpResponseBuilder throttledResponseBuilder = new org.mule.module.http.internal.domain.response.HttpResponseBuilder().setStatusCode(MESSAGE_DISCARD_STATUS_CODE).setReasonPhrase(MESSAGE_DISCARD_REASON_PHRASE).setEntity(new InputStreamHttpEntity(new ByteArrayInputStream(MESSAGE_DISCARD_MESSAGE_BODY.getBytes())));
        this.addThrottlingHeaders(throttledResponseBuilder);
        this.responseReadyCallback.responseReady(throttledResponseBuilder.build(), this.getLogCompletionCallback());
    }

    private void addThrottlingHeaders(org.mule.module.http.internal.domain.response.HttpResponseBuilder throttledResponseBuilder) {
        Map<String, String> throttlingHeaders = this.getThrottlingHeaders();
        for (String string : throttlingHeaders.keySet()) {
            throttledResponseBuilder.addHeader(string, throttlingHeaders.get(string));
        }
        for (Map.Entry entry : this.extraHeaders.entrySet()) {
            throttledResponseBuilder.addHeader((String)entry.getKey(), entry.getValue());
        }
    }

    private ResponseStatusCallback getLogCompletionCallback() {
        return new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable throwable) {
                logger.info("Failure sending throttled response " + throwable.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(throwable.getMessage(), throwable);
                }
            }

            @Override
            public void responseSendSuccessfully() {
                if (logger.isDebugEnabled()) {
                    logger.debug("throttled response sent successfully");
                }
            }
        };
    }

    public void setThrottlingPolicyStatistics(long remainingRequestInCurrentPeriod, long maximumRequestAllowedPerPeriod, long timeUntilNextPeriodInMillis) {
        this.httpThrottlingHeadersMapBuilder.setThrottlingPolicyStatistics(remainingRequestInCurrentPeriod, maximumRequestAllowedPerPeriod, timeUntilNextPeriodInMillis);
    }

    private Map<String, String> getThrottlingHeaders() {
        return this.httpThrottlingHeadersMapBuilder.build();
    }

    public void addExtraHeader(String headerName, String value) {
        this.extraHeaders.put(headerName, value);
    }
}

