/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.api.DefaultMuleException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.http.internal.domain.OutputHandlerHttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.module.http.internal.listener.grizzly.BaseResponseCompletionHandler;

public class ResponseDeferringCompletionHandler
extends BaseResponseCompletionHandler {
    public static final String HTTP_RESPONSE_DEFERRING_COMPLETION_TIMEOUT_PROPERTY = "mule.http.response.deferring.completion.timeout";
    public static final String FAILURE_WHILE_PROCESSING_HTTP_RESPONSE_BODY = "Failure while processing HTTP response body.";
    private final MemoryManager memoryManager;
    private final HttpResponsePacket httpResponsePacket;
    private final OutputHandler outputHandler;
    private final ResponseStatusCallback responseStatusCallback;
    private final CompletionOutputStream outputStream;
    private final Semaphore sending = new Semaphore(1);
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final Integer httpResponseDeferringCompletionTimeout = Integer.getInteger("mule.http.response.deferring.completion.timeout", -1);
    private volatile boolean isDone;
    private volatile AtomicBoolean isCompleted = new AtomicBoolean(false);

    public ResponseDeferringCompletionHandler(FilterChainContext ctx, HttpRequestPacket request, HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
        super(ctx);
        Preconditions.checkArgument((boolean)(httpResponse.getEntity() instanceof OutputHandlerHttpEntity), (Object)"http response must have an output handler entity");
        this.httpResponsePacket = this.buildHttpResponsePacket(request, httpResponse);
        this.outputHandler = ((OutputHandlerHttpEntity)httpResponse.getEntity()).getOutputHandler();
        this.memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        this.responseStatusCallback = responseStatusCallback;
        this.outputStream = new CompletionOutputStream((CompletionHandler)this);
    }

    @Override
    protected void doStart() throws IOException {
        try {
            this.outputHandler.write(null, (OutputStream)this.outputStream);
        }
        catch (IOException e) {
            if (this.outputStream.isWritten()) {
                this.logger.warn("Failure while processing HTTP response body. Cancelling.", (Throwable)e);
                this.outputStream.close();
            }
            throw e;
        }
    }

    public void completed(WriteResult result) {
        if (this.isDone) {
            this.doComplete();
        }
        this.sending.release();
    }

    private void doComplete() {
        if (this.isCompleted.compareAndSet(false, true)) {
            this.responseStatusCallback.responseSendSuccessfully();
            this.ctx.notifyDownstream(HttpServerFilter.RESPONSE_COMPLETE_EVENT);
            this.resume();
        }
    }

    @Override
    public void cancelled() {
        super.cancelled();
        this.responseStatusCallback.responseSendFailure((Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"HTTP response sending task was cancelled")));
        this.resume();
    }

    @Override
    public void failed(Throwable throwable) {
        super.failed(throwable);
        this.resume();
        this.failed.set(true);
        this.sending.release();
    }

    private void resume() {
        this.ctx.resume(this.ctx.getStopAction());
    }

    class CompletionOutputStream
    extends OutputStream {
        private Buffer buffer = this.getBuffer(8192);
        private boolean written = false;
        private CompletionHandler completionHandler;

        CompletionOutputStream(CompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
        }

        @Override
        public void write(int b) throws IOException {
            this.flushIfNecessary(1);
            this.buffer.put((byte)b);
            this.buffer.limit(this.buffer.position() + 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.flushIfNecessary(len);
            this.buffer.put(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.flush(8192);
        }

        @Override
        public void close() throws IOException {
            if (!ResponseDeferringCompletionHandler.this.isDone) {
                HttpTrailer content = ResponseDeferringCompletionHandler.this.httpResponsePacket.httpTrailerBuilder().build();
                if (this.hasPendingData()) {
                    content = this.getBufferAsContent().append((HttpContent)content);
                }
                try {
                    this.acquireSendingSemaphore();
                    ResponseDeferringCompletionHandler.this.isDone = true;
                    ResponseDeferringCompletionHandler.this.ctx.write((Object)content, this.completionHandler);
                    this.written = true;
                    if (!ResponseDeferringCompletionHandler.this.httpResponsePacket.isChunked()) {
                        ResponseDeferringCompletionHandler.this.sending.release();
                        ResponseDeferringCompletionHandler.this.doComplete();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void acquireSendingSemaphore() throws InterruptedException, IOException {
            if (ResponseDeferringCompletionHandler.this.httpResponseDeferringCompletionTimeout != -1) {
                boolean acquired = ResponseDeferringCompletionHandler.this.sending.tryAcquire(ResponseDeferringCompletionHandler.this.httpResponseDeferringCompletionTimeout.intValue(), TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new IOException(ResponseDeferringCompletionHandler.FAILURE_WHILE_PROCESSING_HTTP_RESPONSE_BODY);
                }
            } else {
                ResponseDeferringCompletionHandler.this.sending.acquire();
            }
        }

        public boolean isWritten() {
            return this.written;
        }

        private void flushIfNecessary(int writeLength) throws IOException {
            if (this.buffer.remaining() < writeLength) {
                this.flush(Math.max(writeLength, 8192));
            }
        }

        public void flush(int bufferSize) throws IOException {
            if (this.hasPendingData()) {
                try {
                    this.acquireSendingSemaphore();
                    if (ResponseDeferringCompletionHandler.this.failed.get()) {
                        throw new IOException(ResponseDeferringCompletionHandler.FAILURE_WHILE_PROCESSING_HTTP_RESPONSE_BODY);
                    }
                    ResponseDeferringCompletionHandler.this.ctx.write((Object)this.getBufferAsContent(), this.completionHandler);
                    this.written = true;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.buffer.release();
            }
            this.buffer = this.getBuffer(bufferSize);
        }

        private boolean hasPendingData() {
            return this.buffer.capacity() != this.buffer.remaining();
        }

        private HttpContent getBufferAsContent() {
            this.buffer.flip();
            return ResponseDeferringCompletionHandler.this.httpResponsePacket.httpContentBuilder().content(this.buffer).build();
        }

        private Buffer getBuffer(int bufferSize) {
            return ResponseDeferringCompletionHandler.this.memoryManager.allocate(bufferSize);
        }
    }
}

