/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp.notification;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.context.notification.CustomNotification;
import org.mule.context.notification.EndpointMessageNotification;

public class SftpTransportNotification
extends CustomNotification {
    private static final long serialVersionUID = 4662315555948069782L;
    protected static final Log logger = LogFactory.getLog(EndpointMessageNotification.class);
    private static final int SFTP_ACTION_BASE = 200000;
    public static final int SFTP_GET_ACTION = 200001;
    public static final int SFTP_PUT_ACTION = 200002;
    public static final int SFTP_RENAME_ACTION = 200003;
    public static final int SFTP_DELETE_ACTION = 200004;
    public static final String SFTP_GET_ACTION_MSG = "sftp.get";
    public static final String SFTP_PUT_ACTION_MSG = "sftp.put";
    public static final String SFTP_RENAME_ACTION_MSG = "sftp.rename";
    public static final String SFTP_DELETE_ACTION_MSG = "sftp.delete";
    private ImmutableEndpoint endpoint;
    private String info;
    private long size;

    public SftpTransportNotification(MuleMessage resource, ImmutableEndpoint endpoint, String resourceIdentifier, int action, String info, long size) {
        super((Object)resource, action, resourceIdentifier);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"*** SftpTransportNotification object created ***");
        }
        this.endpoint = endpoint;
        this.info = info;
        this.size = size;
    }

    protected String getPayloadToString() {
        try {
            return ((MuleMessage)this.source).getPayloadAsString();
        }
        catch (Exception e) {
            return this.source.toString();
        }
    }

    public String toString() {
        return this.EVENT_NAME + "{action = " + SftpTransportNotification.getActionName((int)this.action) + ", endpoint = " + this.endpoint.getEndpointURI() + ", info = " + this.info + ", size = " + this.size + ", resourceIdentifier = " + this.resourceIdentifier + ", timestamp = " + this.timestamp + ", serverId = " + this.getServerId() + ", message = " + this.source + "}";
    }

    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String getInfo() {
        return this.info;
    }

    public long getSize() {
        return this.size;
    }

    static {
        SftpTransportNotification.registerAction((String)SFTP_GET_ACTION_MSG, (int)200001);
        SftpTransportNotification.registerAction((String)SFTP_PUT_ACTION_MSG, (int)200002);
        SftpTransportNotification.registerAction((String)SFTP_RENAME_ACTION_MSG, (int)200003);
        SftpTransportNotification.registerAction((String)SFTP_DELETE_ACTION_MSG, (int)200004);
    }
}

