/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.ReplyToHandler;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.outbound.OutboundNotificationMessageProcessor;
import org.mule.tck.SensingNullReplyToHandler;

public class OutboundNotificationMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    @Test
    public void testDispatch() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        OutboundNotificationMessageProcessor mp = new OutboundNotificationMessageProcessor(endpoint);
        MuleEvent event = this.createTestOutboundEvent();
        mp.process(event);
        this.assertMessageNotification(listener, endpoint, event, 851);
    }

    @Test
    public void testSend() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        OutboundNotificationMessageProcessor mp = new OutboundNotificationMessageProcessor(endpoint);
        MuleEvent event = this.createTestOutboundEvent();
        mp.process(event);
        this.assertMessageNotification(listener, endpoint, event, 852);
    }

    @Test
    public void testSendNonBlocking() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        OutboundNotificationMessageProcessor mp = new OutboundNotificationMessageProcessor(endpoint);
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        MuleEvent event = OutboundNotificationMessageProcessorTestCase.getNonBlockingTestEventUsingFlow("Test Message", (ReplyToHandler)nullReplyToHandler);
        mp.process(event);
        this.assertMessageNotification(listener, endpoint, event, 852);
    }

    private void assertMessageNotification(AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener, OutboundEndpoint endpoint, MuleEvent event, int action) throws InterruptedException {
        Assert.assertThat((Object)listener.latch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)listener.messageNotification.getAction(), (Matcher)CoreMatchers.equalTo((Object)action));
        Assert.assertThat((Object)listener.messageNotification.getEndpoint(), (Matcher)CoreMatchers.equalTo((Object)endpoint.getEndpointURI().getUri().toString()));
        Assert.assertThat((Object)listener.messageNotification.getSource(), (Matcher)CoreMatchers.instanceOf(MuleMessage.class));
        Assert.assertThat((Object)listener.messageNotification.getSource().getPayload(), (Matcher)CoreMatchers.equalTo((Object)event.getMessage().getPayload()));
    }
}

