/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.RoundRobin;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class RoundRobinTestCase
extends AbstractMuleContextTestCase {
    private static final int NUMBER_OF_ROUTES = 10;
    private static final int NUMBER_OF_MESSAGES = 10;
    private final AtomicInteger messageNumber = new AtomicInteger(0);

    public RoundRobinTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testRoundRobin() throws Exception {
        RoundRobin rr = new RoundRobin();
        MuleSession session = RoundRobinTestCase.getTestSession(null, muleContext);
        ArrayList<TestProcessor> routes = new ArrayList<TestProcessor>(10);
        for (int i = 0; i < 10; ++i) {
            routes.add(new TestProcessor());
        }
        rr.setRoutes(new ArrayList(routes));
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(new TestDriver(session, (MessageProcessor)rr, 10, (FlowConstruct)RoundRobinTestCase.getTestService())));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        for (TestProcessor route : routes) {
            Assert.assertEquals((long)10L, (long)route.getCount());
        }
    }

    @Test
    public void usesFirstRouteOnFirstRequest() throws Exception {
        RoundRobin roundRobin = new RoundRobin();
        ArrayList<MessageProcessor> routes = new ArrayList<MessageProcessor>(2);
        MessageProcessor route1 = (MessageProcessor)Mockito.mock(MessageProcessor.class, (String)"route1");
        routes.add(route1);
        MessageProcessor route2 = (MessageProcessor)Mockito.mock(MessageProcessor.class, (String)"route2");
        routes.add(route2);
        roundRobin.setRoutes(new ArrayList(routes));
        DefaultMuleMessage message = new DefaultMuleMessage(Collections.singletonList("Test Message"), muleContext);
        roundRobin.process((MuleEvent)new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.REQUEST_RESPONSE, null, (MuleSession)null));
        ((MessageProcessor)Mockito.verify((Object)route1)).process((MuleEvent)Matchers.any(MuleEvent.class));
        ((MessageProcessor)Mockito.verify((Object)route2, (VerificationMode)Mockito.never())).process((MuleEvent)Matchers.any(MuleEvent.class));
    }

    static class TestProcessor
    implements MessageProcessor {
        private AtomicInteger count = new AtomicInteger(0);
        private List<Object> payloads = new ArrayList<Object>();

        TestProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.payloads.add(event.getMessage().getPayload());
            if (this.count.incrementAndGet() % 3 == 0) {
                throw new DefaultMuleException("Mule Exception!");
            }
            return null;
        }

        public int getCount() {
            return this.count.get();
        }
    }

    class TestDriver
    implements Runnable {
        private MessageProcessor target;
        private int numMessages;
        private MuleSession session;
        private FlowConstruct flowConstruct;

        TestDriver(MuleSession session, MessageProcessor target, int numMessages, FlowConstruct flowConstruct) {
            this.target = target;
            this.numMessages = numMessages;
            this.session = session;
            this.flowConstruct = flowConstruct;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numMessages; ++i) {
                DefaultMuleMessage msg = new DefaultMuleMessage((Object)("Test Message" + RoundRobinTestCase.this.messageNumber.getAndIncrement()), muleContext);
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.REQUEST_RESPONSE, this.flowConstruct, this.session);
                try {
                    this.target.process((MuleEvent)event);
                    continue;
                }
                catch (MuleException muleException) {
                    // empty catch block
                }
            }
        }
    }
}

