/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ChainingRouter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ChainingRouterTestCase
extends AbstractMuleContextTestCase {
    private MuleSession session;
    private ChainingRouter router;
    private List<OutboundEndpoint> endpoints;
    private OutboundEndpoint mockEndpoint1;
    private OutboundEndpoint mockEndpoint2;
    private OutboundEndpoint mockEndpoint3;

    public ChainingRouterTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = (MuleSession)Mockito.mock(MuleSession.class);
        this.router = new ChainingRouter();
        this.router.setMuleContext(muleContext);
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = ChainingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint1);
        this.mockEndpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = ChainingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint2);
        this.mockEndpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        this.router.setFilter((Filter)filter);
        this.endpoints = new ArrayList<OutboundEndpoint>();
        this.endpoints.add(this.mockEndpoint1);
        this.endpoints.add(this.mockEndpoint2);
        this.router.setRoutes(new ArrayList<OutboundEndpoint>(this.endpoints));
        Assert.assertEquals((Object)filter, (Object)this.router.getFilter());
    }

    @Test
    public void testChainingOutboundRouterSynchronous() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent responseEvent = new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext);
        Mockito.when((Object)this.mockEndpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(responseEvent));
        Mockito.when((Object)this.mockEndpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(responseEvent));
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNotNull((String)"This is a sync call, we need a result returned.", (Object)result);
        Assert.assertEquals((Object)message, (Object)result.getMessage());
    }

    @Test
    public void testChainingOutboundRouterSynchronousWithTemplate() throws Exception {
        OutboundEndpoint endpoint3 = ChainingRouterTestCase.getTestOutboundEndpoint("Test3Provider", "test://foo?[barValue]&exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint3);
        this.mockEndpoint3 = RouterTestUtils.createMockEndpoint(endpoint3);
        this.router.addRoute((MessageProcessor)this.mockEndpoint3);
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("barValue", "bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", messageProperties, muleContext);
        Assert.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent responseEvent = new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext);
        ImmutableEndpoint ep = (ImmutableEndpoint)this.router.getRoute(2, (MuleEvent)responseEvent);
        Assert.assertEquals((Object)"test://foo?bar&exchangePattern=request-response", (Object)ep.getEndpointURI().toString());
        Mockito.when((Object)this.mockEndpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(responseEvent));
        Mockito.when((Object)this.mockEndpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(responseEvent));
        Mockito.when((Object)this.mockEndpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(responseEvent));
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNotNull((String)"This is a sync call, we need a result returned.", (Object)result);
        Assert.assertEquals((Object)message, (Object)result.getMessage());
    }

    @Test
    public void testChainingOutboundRouterAsynchronous() throws Exception {
        OutboundEndpoint endpoint1 = ChainingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test");
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mep1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = ChainingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test");
        Assert.assertNotNull((Object)endpoint2);
        OutboundEndpoint mep2 = RouterTestUtils.createMockEndpoint(endpoint2);
        this.endpoints.clear();
        this.endpoints.add(mep1);
        this.endpoints.add(mep2);
        this.router.setRoutes(new ArrayList<OutboundEndpoint>(this.endpoints));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        message = new DefaultMuleMessage((Object)"test event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext);
        Mockito.when((Object)mep1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mep2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNull((String)"Async call shouldn't return any result.", (Object)result);
    }

    @Test
    public void testBrokenChain() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Mockito.when((Object)this.mockEndpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNull((Object)result);
    }
}

