/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.serialization.SerializationException;
import org.mule.serialization.internal.ClassSpecificObjectSerializer;
import org.mule.serialization.internal.JavaObjectSerializer;
import org.mule.session.DefaultMuleSession;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class SerializeAndEncodeSessionHandlerTestCase
extends AbstractMuleTestCase {
    private static final String INVALID_CLASS_MESSAGE = "Invalid Class";
    private static final String SERIALIZATION_EXCEPTION_MESSAGE = "Serialization Exception";
    private static final String DUMMY_SESSION_STRING = "DUMMYSESSIONSTRING";
    private static final int SIGNATURE_LENGTH = 32;
    @Mock
    private MuleMessage message;
    @Mock
    private MuleContext context;
    @Mock
    private ClassSpecificObjectSerializer serializer;

    @Test
    public void returnNullSessionWhenIncompatibleClass() throws Exception {
        Mockito.when((Object)this.message.getMuleContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.message.getInboundProperty("MULE_SESSION")).thenReturn((Object)DUMMY_SESSION_STRING);
        Mockito.when((Object)this.context.getObjectSerializer()).thenReturn((Object)this.serializer);
        Mockito.when((Object)this.serializer.deserialize((byte[])Mockito.any(byte[].class), (ClassLoader)org.mockito.Matchers.any(ClassLoader.class))).thenThrow(new Throwable[]{new SerializationException(SERIALIZATION_EXCEPTION_MESSAGE, (Throwable)new InvalidClassException(INVALID_CLASS_MESSAGE))});
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        MuleSession session = handler.retrieveSessionInfoFromMessage(this.message);
        Assert.assertThat((Object)session, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void cycleWithSignedSession() throws MuleException {
        Mockito.when((Object)this.message.getMuleContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.message.getInboundProperty("MULE_ENDPOINT")).thenReturn((Object)"http://myhost/lalala");
        Mockito.when((Object)this.context.getObjectSerializer()).thenReturn((Object)new JavaObjectSerializer());
        Mockito.when((Object)this.context.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        ArgumentCaptor serializedSessionCaptor = ArgumentCaptor.forClass(String.class);
        DefaultMuleSession session = new DefaultMuleSession();
        session.setProperty("hello", (Serializable)((Object)"world"));
        handler.storeSessionInfoToMessage((MuleSession)session, this.message);
        ((MuleMessage)Mockito.verify((Object)this.message)).setOutboundProperty((String)org.mockito.Matchers.eq((Object)"MULE_SESSION"), serializedSessionCaptor.capture());
        Mockito.when((Object)this.message.getInboundProperty("MULE_SESSION")).thenReturn(serializedSessionCaptor.getValue());
        MuleSession newSession = handler.retrieveSessionInfoFromMessage(this.message);
        Assert.assertThat((Object)newSession, (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((String)newSession.getProperty("hello")), (Matcher)Matchers.is((Object)"world"));
    }

    @Test
    public void returnNullSessionWhenUnsignedSession() throws MuleException {
        Mockito.when((Object)this.message.getMuleContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.context.getObjectSerializer()).thenReturn((Object)new JavaObjectSerializer());
        Mockito.when((Object)this.context.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        ArgumentCaptor serializedSessionCaptor = ArgumentCaptor.forClass(String.class);
        handler.storeSessionInfoToMessage((MuleSession)new DefaultMuleSession(), this.message);
        ((MuleMessage)Mockito.verify((Object)this.message)).setOutboundProperty((String)Mockito.eq((Object)"MULE_SESSION"), serializedSessionCaptor.capture());
        byte[] signedData = ((String)serializedSessionCaptor.getValue()).getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[signedData.length - 32];
        System.arraycopy(signedData, 32, data, 0, signedData.length - 32);
        Mockito.when((Object)this.message.getInboundProperty("MULE_SESSION")).thenReturn((Object)new String(data, StandardCharsets.UTF_8));
        MuleSession session = handler.retrieveSessionInfoFromMessage(this.message);
        Assert.assertThat((Object)session, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void returnNullSessionWhenInvalidSignatureSession() throws MuleException, IOException {
        Mockito.when((Object)this.message.getMuleContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.context.getObjectSerializer()).thenReturn((Object)new JavaObjectSerializer());
        Mockito.when((Object)this.context.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        ArgumentCaptor serializedSessionCaptor = ArgumentCaptor.forClass(String.class);
        handler.storeSessionInfoToMessage((MuleSession)new DefaultMuleSession(), this.message);
        ((MuleMessage)Mockito.verify((Object)this.message)).setOutboundProperty((String)Mockito.eq((Object)"MULE_SESSION"), serializedSessionCaptor.capture());
        String encodeBytes = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaAAAAAAAAAAAAAAAAAAAAAAAAaaaRRRRRRRRRRRGGGGGGGGGHHHHHHhhh==";
        System.out.println(" >> " + (String)serializedSessionCaptor.getValue());
        String tamperedSignature = ((String)serializedSessionCaptor.getValue()).substring(encodeBytes.length());
        Mockito.when((Object)this.message.getInboundProperty("MULE_SESSION")).thenReturn((Object)tamperedSignature);
        MuleSession session = handler.retrieveSessionInfoFromMessage(this.message);
        Assert.assertThat((Object)session, (Matcher)CoreMatchers.nullValue());
    }
}

