/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Arrays;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Every;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.simple.ByteArrayToObject;
import org.mule.transformer.simple.ByteArrayToSerializable;
import org.mule.transformer.simple.ObjectToString;

@SmallTest
public class CompositeConverterTestCase {
    private Converter mockConverterA = (Converter)Mockito.mock(Converter.class);
    private Converter mockConverterB = (Converter)Mockito.mock(Converter.class);

    @Test(expected=IllegalArgumentException.class)
    public void rejectsEmptyCompositeTransformer() throws Exception {
        new CompositeConverter(new Converter[0]);
    }

    @Test
    public void isSourceTypeSupported() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isSourceTypeSupported(String.class)).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isSourceTypeSupported(String.class));
    }

    @Test
    public void isSourceDataTypeSupported() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isSourceDataTypeSupported(DataType.STRING_DATA_TYPE)).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isSourceDataTypeSupported(DataType.STRING_DATA_TYPE));
    }

    @Test
    public void getSourceTypes() {
        Class[] dataTypes = new Class[]{String.class};
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.getSourceTypes()).thenReturn(Arrays.asList(dataTypes));
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertEquals(String.class, chain.getSourceTypes().get(0));
    }

    @Test
    public void getSourceDataTypes() {
        DataType[] dataTypes = new DataType[]{DataType.STRING_DATA_TYPE};
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.getSourceDataTypes()).thenReturn(Arrays.asList(dataTypes));
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertEquals((Object)DataType.STRING_DATA_TYPE, chain.getSourceDataTypes().get(0));
    }

    @Test
    public void isAcceptNull() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isAcceptNull()).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isAcceptNull());
    }

    @Test
    public void isIgnoreBadInput() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        Mockito.when((Object)converter.isIgnoreBadInput()).thenReturn((Object)true);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        Assert.assertTrue((boolean)chain.isIgnoreBadInput());
    }

    @Test
    public void setReturnClass() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        chain.setReturnClass(String.class);
        ((Converter)Mockito.verify((Object)converter, (VerificationMode)Mockito.atLeastOnce())).setReturnClass(String.class);
    }

    @Test
    public void setReturnDataType() {
        Converter converter = (Converter)Mockito.mock(Converter.class);
        CompositeConverter chain = new CompositeConverter(new Converter[]{converter});
        chain.setReturnDataType(DataType.STRING_DATA_TYPE);
        ((Converter)Mockito.verify((Object)converter, (VerificationMode)Mockito.atLeastOnce())).setReturnDataType(DataType.STRING_DATA_TYPE);
    }

    @Test
    public void getReturnClass() {
        ((Converter)Mockito.doReturn(String.class).when((Object)this.mockConverterB)).getReturnClass();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals(String.class, (Object)compositeConverter.getReturnClass());
    }

    @Test
    public void getReturnDataType() {
        ((Converter)Mockito.doReturn((Object)DataType.STRING_DATA_TYPE).when((Object)this.mockConverterB)).getReturnDataType();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((Object)DataType.STRING_DATA_TYPE, (Object)compositeConverter.getReturnDataType());
    }

    @Test
    public void getMimeType() {
        ((Converter)Mockito.doReturn((Object)"application/xml").when((Object)this.mockConverterB)).getMimeType();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((String)"application/xml", (String)compositeConverter.getMimeType());
    }

    @Test
    public void getEncoding() {
        ((Converter)Mockito.doReturn((Object)"UTF-8").when((Object)this.mockConverterB)).getEncoding();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((String)"UTF-8", (String)compositeConverter.getEncoding());
    }

    @Test
    public void getEndpoint() {
        ImmutableEndpoint mockImmutableEndpoint = (ImmutableEndpoint)Mockito.mock(ImmutableEndpoint.class);
        ((Converter)Mockito.doReturn((Object)mockImmutableEndpoint).when((Object)this.mockConverterA)).getEndpoint();
        ((Converter)Mockito.doReturn((Object)mockImmutableEndpoint).when((Object)this.mockConverterB)).getEndpoint();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Assert.assertEquals((Object)mockImmutableEndpoint, (Object)compositeConverter.getEndpoint());
    }

    @Test
    public void setEndpoint() {
        ImmutableEndpoint mockImmutableEndpoint = (ImmutableEndpoint)Mockito.mock(ImmutableEndpoint.class);
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.setEndpoint(mockImmutableEndpoint);
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).setEndpoint(mockImmutableEndpoint);
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).setEndpoint(mockImmutableEndpoint);
    }

    @Test
    public void priorityWeighting() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Mockito.when((Object)this.mockConverterA.getPriorityWeighting()).thenReturn((Object)1);
        Mockito.when((Object)this.mockConverterB.getPriorityWeighting()).thenReturn((Object)2);
        int priorityWeighting = compositeConverter.getPriorityWeighting();
        Assert.assertEquals((int)3, (int)priorityWeighting);
    }

    @Test
    public void initialise() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.initialise();
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).initialise();
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).initialise();
    }

    @Test
    public void dispose() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.dispose();
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).dispose();
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).dispose();
    }

    @Test
    public void setMuleContext() {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        compositeConverter.setMuleContext(mockMuleContext);
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.atLeastOnce())).setMuleContext(mockMuleContext);
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.atLeastOnce())).setMuleContext(mockMuleContext);
    }

    @Test
    public void transform() throws Exception {
        ((Converter)Mockito.doReturn((Object)"MyOutput1").when((Object)this.mockConverterA)).transform(Matchers.any());
        ((Converter)Mockito.doReturn((Object)"UTF-8").when((Object)this.mockConverterA)).getEncoding();
        ((Converter)Mockito.doReturn((Object)"MyOutput2").when((Object)this.mockConverterB)).transform(Matchers.eq((Object)"MyOutput1"), (String)Matchers.eq((Object)"UTF-8"));
        ((Converter)Mockito.doReturn((Object)"UTF-8").when((Object)this.mockConverterB)).getEncoding();
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        Object output = compositeConverter.transform((Object)"MyInput");
        ((Converter)Mockito.verify((Object)this.mockConverterA, (VerificationMode)Mockito.times((int)1))).transform((Object)"MyInput");
        ((Converter)Mockito.verify((Object)this.mockConverterB, (VerificationMode)Mockito.times((int)1))).transform((Object)"MyOutput1", "UTF-8");
        Assert.assertEquals((Object)"MyOutput2", (Object)output);
    }

    @Test
    public void appliesTransformerChainOnMessage() throws Exception {
        CompositeConverter compositeConverter = new CompositeConverter(new Converter[]{this.mockConverterA, this.mockConverterB});
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        ((MuleEvent)Mockito.doReturn((Object)message).when((Object)event)).getMessage();
        compositeConverter.process(event);
        ((MuleMessage)Mockito.verify((Object)message, (VerificationMode)Mockito.times((int)1))).applyTransformers(event, new Transformer[]{compositeConverter});
    }

    @Test
    public void equalsReturnsTrueOnCompositeConvertersWithSameNameAndSameTransformationChain() {
        ByteArrayToObject byteArrayToObjectConverter = new ByteArrayToObject();
        ObjectToString byteArrayToInputStreamConverter = new ObjectToString();
        CompositeConverter compositeConverterA = new CompositeConverter(new Converter[]{byteArrayToObjectConverter, byteArrayToInputStreamConverter});
        CompositeConverter compositeConverterB = new CompositeConverter(new Converter[]{byteArrayToObjectConverter, byteArrayToInputStreamConverter});
        MatcherAssert.assertThat((Object)compositeConverterA, (Matcher)IsEqual.equalTo((Object)compositeConverterB));
    }

    @Test
    public void equalsReturnsFalseOnCompositeConvertersWithDifferentTransformationChain() {
        ByteArrayToObject byteArrayToObjectConverter = new ByteArrayToObject();
        ObjectToString byteArrayToInputStreamConverter = new ObjectToString();
        CompositeConverter compositeConverterA = new CompositeConverter(new Converter[]{byteArrayToObjectConverter, byteArrayToInputStreamConverter});
        CompositeConverter compositeConverterB = new CompositeConverter(new Converter[]{byteArrayToInputStreamConverter, byteArrayToObjectConverter});
        MatcherAssert.assertThat((Object)compositeConverterA, (Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)compositeConverterB)));
    }

    @Test
    public void hashCodeForCompositeConvertersChangesWithDifferentTransformationChain() {
        ByteArrayToObject byteArrayToObjectConverter = new ByteArrayToObject();
        ObjectToString byteArrayToInputStreamConverter = new ObjectToString();
        ByteArrayToObject byteArrayToObjectConverter2 = new ByteArrayToObject();
        ObjectToString byteArrayToInputStreamConverter2 = new ObjectToString();
        ByteArrayToSerializable byteArrayToSerializableConverter = new ByteArrayToSerializable();
        int hashCodeConverterA = new CompositeConverter(new Converter[]{byteArrayToObjectConverter, byteArrayToInputStreamConverter}).hashCode();
        int hashCodeConverterAClone = new CompositeConverter(new Converter[]{byteArrayToObjectConverter, byteArrayToInputStreamConverter}).hashCode();
        int hashCodeConverterAnotherClone = new CompositeConverter(new Converter[]{byteArrayToObjectConverter2, byteArrayToInputStreamConverter2}).hashCode();
        int hashCodeConverterReverseClone = new CompositeConverter(new Converter[]{byteArrayToInputStreamConverter, byteArrayToObjectConverter}).hashCode();
        int hashCodeConverterNotAClone = new CompositeConverter(new Converter[]{byteArrayToInputStreamConverter, byteArrayToSerializableConverter}).hashCode();
        MatcherAssert.assertThat(Arrays.asList(hashCodeConverterAClone), (Matcher)Every.everyItem((Matcher)IsEqual.equalTo((Object)hashCodeConverterA)));
        MatcherAssert.assertThat(Arrays.asList(hashCodeConverterReverseClone, hashCodeConverterNotAClone, hashCodeConverterAnotherClone), (Matcher)Every.everyItem((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)hashCodeConverterA))));
    }
}

