/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.builder.MockTransformerBuilder;
import org.mule.transformer.graph.GraphTransformerResolver;
import org.mule.transformer.simple.ObjectToInputStream;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class GraphTransformerResolverTestCase
extends AbstractMuleTestCase {
    private static final int CONCURRENCY_TEST_SIZE = 400;
    private static final int MAX_TIMEOUT_SECONDS = 20;
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    private static final DataType INPUT_STREAM_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"INPUT_STREAM_DATA_TYPE");
    private static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");
    private GraphTransformerResolver graphResolver = new GraphTransformerResolver();

    @BeforeClass
    public static void setupDataTypes() {
        ((DataType)Mockito.doReturn((Object)true).when((Object)XML_DATA_TYPE)).isCompatibleWith(XML_DATA_TYPE);
        ((DataType)Mockito.doReturn(XML_CLASS.class).when((Object)XML_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)JSON_DATA_TYPE)).isCompatibleWith(JSON_DATA_TYPE);
        ((DataType)Mockito.doReturn(JSON_CLASS.class).when((Object)JSON_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)INPUT_STREAM_DATA_TYPE)).isCompatibleWith(INPUT_STREAM_DATA_TYPE);
        ((DataType)Mockito.doReturn(INPUT_STREAM_CLASS.class).when((Object)INPUT_STREAM_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)STRING_DATA_TYPE)).isCompatibleWith(STRING_DATA_TYPE);
        ((DataType)Mockito.doReturn(STRING_CLASS.class).when((Object)STRING_DATA_TYPE)).getType();
    }

    @Test
    public void cachesResolvedTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer1, (Matcher)Matchers.sameInstance((Object)transformer2));
    }

    @Test
    public void clearsCacheWhenAddsConverter() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToXml")).from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer1, (Matcher)Matchers.notNullValue());
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)xmlToString, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
    }

    @Test
    public void ignoresAddedTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToXml")).from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer1, (Matcher)Matchers.notNullValue());
        Transformer xmlToString = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graphResolver.transformerChange(xmlToString, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer1, (Matcher)Matchers.sameInstance((Object)transformer2));
    }

    @Test
    public void ignoresRemovedTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToXml")).from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer1, (Matcher)Matchers.notNullValue());
        Transformer xmlToString = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graphResolver.transformerChange(xmlToString, TransformerResolver.RegistryAction.REMOVED);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer1, (Matcher)Matchers.sameInstance((Object)transformer2));
    }

    @Test
    public void clearsCacheWhenRemovesTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Mockito.when((Object)xmlToJson.getName()).thenReturn((Object)"xmlToJson");
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        Mockito.when((Object)inputStreamToXml.getName()).thenReturn((Object)"inputStreamToXml");
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer, (Matcher)Matchers.notNullValue());
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.REMOVED);
        transformer = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer, (Matcher)Matchers.nullValue());
    }

    @Test
    public void resolvesTransformersWithDifferentLength() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)xmlToJson, (Matcher)Matchers.sameInstance((Object)transformer));
    }

    @Test
    public void resolvesTransformersWithSameLengthAndDifferentWeight() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(2)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToString, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)stringToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer, (Matcher)Matchers.instanceOf(CompositeConverter.class));
        CompositeConverter compositeConverter = (CompositeConverter)transformer;
        MatcherAssert.assertThat((Object)compositeConverter.getConverters(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)xmlToInputStream, (Matcher)Matchers.sameInstance(compositeConverter.getConverters().get(0)));
        MatcherAssert.assertThat((Object)inputStreamToJson, (Matcher)Matchers.sameInstance(compositeConverter.getConverters().get(1)));
    }

    @Test
    public void resolvesTransformerWithSameLengthAndSameWeight() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToString, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)stringToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        MatcherAssert.assertThat((Object)transformer, (Matcher)Matchers.instanceOf(CompositeConverter.class));
        CompositeConverter compositeConverter = (CompositeConverter)transformer;
        MatcherAssert.assertThat((Object)compositeConverter.getConverters(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)xmlToInputStream, (Matcher)Matchers.sameInstance(compositeConverter.getConverters().get(0)));
        MatcherAssert.assertThat((Object)inputStreamToJson, (Matcher)Matchers.sameInstance(compositeConverter.getConverters().get(1)));
    }

    @Test
    public void modifyGraphWhileResolvingTransformer() throws ResolverException, InterruptedException {
        final Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        final Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        Runnable addTransformer = new Runnable(){

            @Override
            public void run() {
                GraphTransformerResolverTestCase.this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
                GraphTransformerResolverTestCase.this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
            }
        };
        Runnable resolveTransformer = new Runnable(){

            @Override
            public void run() {
                try {
                    GraphTransformerResolverTestCase.this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
                }
                catch (ResolverException e) {
                    throw new RuntimeException("Error while getting transformer", e);
                }
            }
        };
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (int i = 0; i < 400; ++i) {
            runnables.add(addTransformer);
            runnables.add(resolveTransformer);
        }
        GraphTransformerResolverTestCase.assertConcurrent("Modify transformers while resolving it", runnables, 20);
    }

    @Test
    public void byteArrayToInputStreamWithoutProperty() throws ResolverException {
        this.graphResolver.transformerChange((Transformer)new ObjectToInputStream(), TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(DataTypeFactory.BYTE_ARRAY, DataTypeFactory.INPUT_STREAM);
        MatcherAssert.assertThat((Object)transformer, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void byteArrayToInputStreamWithProperty() throws ResolverException {
        System.setProperty("mule.transformer.byteArrayToInputStream.enable", "true");
        this.graphResolver.transformerChange((Transformer)new ObjectToInputStream(), TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(DataTypeFactory.BYTE_ARRAY, DataTypeFactory.INPUT_STREAM);
        MatcherAssert.assertThat((Object)transformer, (Matcher)Matchers.instanceOf(ObjectToInputStream.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertConcurrent(String message, List<? extends Runnable> runnables, int maxTimeoutSeconds) throws InterruptedException {
        int numThreads = runnables.size();
        final List exceptions = Collections.synchronizedList(new ArrayList());
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        try {
            final CountDownLatch allExecutorThreadsReady = new CountDownLatch(numThreads);
            final CountDownLatch afterInitBlocker = new CountDownLatch(1);
            final CountDownLatch allDone = new CountDownLatch(numThreads);
            for (final Runnable runnable : runnables) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        allExecutorThreadsReady.countDown();
                        try {
                            afterInitBlocker.await();
                            runnable.run();
                        }
                        catch (Throwable e) {
                            exceptions.add(e);
                        }
                        finally {
                            allDone.countDown();
                        }
                    }
                });
            }
            MatcherAssert.assertThat((String)"Timeout initializing threads! Perform long lasting initializations before passing runnables to assertConcurrent", (boolean)allExecutorThreadsReady.await(runnables.size() * 10, TimeUnit.MILLISECONDS));
            afterInitBlocker.countDown();
            MatcherAssert.assertThat((String)(message + " timeout! More than" + maxTimeoutSeconds + "seconds"), (boolean)allDone.await(maxTimeoutSeconds, TimeUnit.SECONDS));
        }
        finally {
            threadPool.shutdownNow();
        }
        MatcherAssert.assertThat(exceptions, (Matcher)Matchers.empty());
    }

    private static class STRING_CLASS {
        private STRING_CLASS() {
        }
    }

    private static class INPUT_STREAM_CLASS {
        private INPUT_STREAM_CLASS() {
        }
    }

    private static class JSON_CLASS {
        private JSON_CLASS() {
        }
    }

    private static class XML_CLASS {
        private XML_CLASS() {
        }
    }
}

