/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import javax.activation.MimeTypeParseException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.AbstractAddVariablePropertyTransformer;
import org.mule.transformer.simple.AddFlowVariableTransformer;
import org.mule.transformer.simple.AddPropertyTransformer;
import org.mule.transformer.simple.AddSessionVariableTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

@RunWith(value=Parameterized.class)
@SmallTest
public class AddVariablePropertyTransformerTestCase
extends AbstractMuleTestCase {
    public static final String ENCODING = "encoding";
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#[string:someValue]";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#[string:someValueNull]";
    public static final String CUSTOM_ENCODING = StandardCharsets.UTF_8.name();
    private MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExpressionManager mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private AbstractAddVariablePropertyTransformer addVariableTransformer;
    private PropertyScope scope;
    private final ArgumentCaptor<DataType> dataTypeCaptor = ArgumentCaptor.forClass(DataType.class);

    public AddVariablePropertyTransformerTestCase(AbstractAddVariablePropertyTransformer abstractAddVariableTransformer, PropertyScope scope) {
        this.addVariableTransformer = abstractAddVariableTransformer;
        this.scope = scope;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new AddFlowVariableTransformer(), PropertyScope.INVOCATION}, {new AddSessionVariableTransformer(), PropertyScope.SESSION}, {new AddPropertyTransformer(), PropertyScope.OUTBOUND});
    }

    @Before
    public void setUpTest() throws MimeTypeParseException {
        this.addVariableTransformer.setEncoding(null);
        this.addVariableTransformer.setMimeType(null);
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(org.mockito.Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.mockMessage)).thenReturn((Object)EXPRESSION_VALUE);
        TypedValue typedValue = new TypedValue((Object)EXPRESSION_VALUE, DataTypeFactory.STRING);
        Mockito.when((Object)this.mockExpressionManager.evaluateTyped(EXPRESSION, this.mockMessage)).thenReturn((Object)typedValue);
        this.addVariableTransformer.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void testAddVariable() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty((String)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_KEY)), org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_VALUE)), (PropertyScope)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)this.scope)), (DataType)this.dataTypeCaptor.capture());
        MatcherAssert.assertThat((Object)this.dataTypeCaptor.getValue(), DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void testAddVariableWithExpressionValue() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(EXPRESSION);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty((String)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_KEY)), org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)EXPRESSION_VALUE)), (PropertyScope)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)this.scope)), (DataType)this.dataTypeCaptor.capture());
        MatcherAssert.assertThat((Object)this.dataTypeCaptor.getValue(), DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void testAddVariableWithExpressionKey() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(EXPRESSION);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty((String)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)EXPRESSION_VALUE)), org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_VALUE)), (PropertyScope)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)this.scope)), (DataType)this.dataTypeCaptor.capture());
        MatcherAssert.assertThat((Object)this.dataTypeCaptor.getValue(), DataTypeMatcher.like(String.class, "*/*", null));
    }

    @Test
    public void testAddVariableWithEncoding() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.setEncoding(CUSTOM_ENCODING);
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty((String)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_KEY)), org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_VALUE)), (PropertyScope)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)this.scope)), (DataType)this.dataTypeCaptor.capture());
        MatcherAssert.assertThat((Object)this.dataTypeCaptor.getValue(), DataTypeMatcher.like(String.class, "*/*", CUSTOM_ENCODING));
    }

    @Test
    public void testAddVariableWithMimeType() throws InitialisationException, TransformerException, MimeTypeParseException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.setMimeType("application/xml");
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).setProperty((String)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_KEY)), org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)PLAIN_STRING_VALUE)), (PropertyScope)org.mockito.Matchers.argThat((Matcher)Matchers.equalTo((Object)this.scope)), (DataType)this.dataTypeCaptor.capture());
        MatcherAssert.assertThat((Object)this.dataTypeCaptor.getValue(), DataTypeMatcher.like(String.class, "application/xml", null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullKey() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithEmptyKey() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddVariableWithNullValue() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setValue(null);
    }

    @Test
    public void testAddVariableWithNullExpressionKeyResult() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(NULL_EXPRESSION);
        this.addVariableTransformer.setValue(PLAIN_STRING_VALUE);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage, (VerificationMode)VerificationModeFactory.times((int)0))).setProperty((String)org.mockito.Matchers.isNull(), (Object)org.mockito.Matchers.anyString(), (PropertyScope)org.mockito.Matchers.anyObject());
    }

    @Test
    public void testAddVariableWithNullExpressionValueResult() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        TypedValue typedValue = new TypedValue(null, DataType.OBJECT_DATA_TYPE);
        Mockito.when((Object)this.mockExpressionManager.evaluateTyped(NULL_EXPRESSION, this.mockMessage)).thenReturn((Object)typedValue);
        this.addVariableTransformer.setValue(NULL_EXPRESSION);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage, (VerificationMode)VerificationModeFactory.times((int)1))).removeProperty(PLAIN_STRING_KEY, this.scope);
    }

    @Test
    public void testAddVariableWithNullPayloadExpressionValueResult() throws InitialisationException, TransformerException {
        this.addVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.addVariableTransformer.setValue(EXPRESSION);
        TypedValue typedValue = new TypedValue(null, DataType.OBJECT_DATA_TYPE);
        Mockito.when((Object)this.mockExpressionManager.evaluateTyped(EXPRESSION, this.mockMessage)).thenReturn((Object)typedValue);
        this.addVariableTransformer.initialise();
        this.addVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage, (VerificationMode)VerificationModeFactory.times((int)1))).removeProperty(PLAIN_STRING_KEY, this.scope);
    }
}

