/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.util.concurrent.Latch;

public class DispatcherPoolTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testDefaultDispatcherPoolConfiguration() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(4);
        Assert.assertEquals((long)4L, (long)connector.getDispatcherThreadingProfile().getPoolExhaustedAction());
        Assert.assertEquals((long)2L, (long)connector.dispatchers.getMaxActive());
        Assert.assertEquals((long)2L, (long)connector.dispatchers.getMaxIdle());
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getWhenExhaustedAction());
        Assert.assertEquals((long)-1L, (long)connector.dispatchers.getMaxWait());
    }

    @Test
    public void testDefaultDispatcherPoolConfigurationThreadingProfileWait() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        Assert.assertEquals((long)0L, (long)connector.getDispatcherThreadingProfile().getPoolExhaustedAction());
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getMaxActive());
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getMaxIdle());
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getWhenExhaustedAction());
        Assert.assertEquals((long)-1L, (long)connector.dispatchers.getMaxWait());
    }

    @Test
    public void testDispatcherPoolDefaultBlockExhaustedAction() throws Exception {
        final TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolMaxWait(100);
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getMaxActive());
        Assert.assertEquals((long)100L, (long)connector.dispatchers.getMaxWait());
        final OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        final Latch dispatcherBorrowedLatch = new Latch();
        final Latch assertedLatch = new Latch();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDispatcher messageDispatcher = (MessageDispatcher)connector.dispatchers.borrowObject((Object)endpoint);
                    dispatcherBorrowedLatch.countDown();
                    assertedLatch.await();
                    connector.dispatchers.returnObject((Object)endpoint, (Object)messageDispatcher);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        dispatcherBorrowedLatch.await();
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getNumActive());
        assertedLatch.countDown();
        connector.dispatchers.borrowObject((Object)endpoint);
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getNumActive());
    }

    @Test
    public void testDispatcherPoolBlockTimeoutExhaustedAction() throws Exception {
        final TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolMaxWait(10);
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getMaxActive());
        Assert.assertEquals((long)10L, (long)connector.dispatchers.getMaxWait());
        final OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        final Latch dispatcherBorrowedLatch = new Latch();
        final Latch assertedLatch = new Latch();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDispatcher messageDispatcher = (MessageDispatcher)connector.dispatchers.borrowObject((Object)endpoint);
                    dispatcherBorrowedLatch.countDown();
                    assertedLatch.await();
                    connector.dispatchers.returnObject((Object)endpoint, (Object)messageDispatcher);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        dispatcherBorrowedLatch.await();
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getNumActive());
        try {
            connector.dispatchers.borrowObject((Object)endpoint);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((long)1L, (long)connector.dispatchers.getNumActive());
        }
        assertedLatch.countDown();
    }

    @Test
    public void testDispatcherPoolGrowExhaustedAction() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolWhenExhaustedAction((byte)2);
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getMaxActive());
        OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        connector.dispatchers.borrowObject((Object)endpoint);
        connector.dispatchers.borrowObject((Object)endpoint);
        Assert.assertEquals((long)2L, (long)connector.dispatchers.getNumActive());
    }

    @Test
    public void testDispatcherPoolFailExhaustedAction() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolWhenExhaustedAction((byte)0);
        Assert.assertEquals((long)1L, (long)connector.dispatchers.getMaxActive());
        OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        connector.dispatchers.borrowObject((Object)endpoint);
        try {
            connector.dispatchers.borrowObject((Object)endpoint);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((long)1L, (long)connector.dispatchers.getNumActive());
        }
    }

    private TestConnector createConnectorWithSingleObjectDispatcherPool(int exhaustedAction) throws Exception {
        TestConnector connector = new TestConnector(muleContext);
        ImmutableThreadingProfile threadingProfile = new ImmutableThreadingProfile(1, 1, 1, 1L, 1L, exhaustedAction, true, null, null);
        connector.setDispatcherThreadingProfile((ThreadingProfile)threadingProfile);
        connector.createReceiver((FlowConstruct)DispatcherPoolTestCase.getTestService(), DispatcherPoolTestCase.getTestInboundEndpoint("test", "test://test"));
        muleContext.getRegistry().registerConnector((Connector)connector);
        return connector;
    }
}

