/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;

public class DispatcherThreadingProfileTestCase
extends AbstractMuleContextTestCase {
    public static int DELAY_TIME = 500;
    public static int WAIT_TIME = DELAY_TIME + DELAY_TIME / 4;
    public static int SERIAL_WAIT_TIME = DELAY_TIME * 2 + DELAY_TIME / 4;
    public static int LONGER_WAIT_TIME = DELAY_TIME * 5;
    private CountDownLatch latch;

    public DispatcherThreadingProfileTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
    }

    @Test
    public void testDefaultThreadingProfileConfiguration() throws MuleException {
        TestConnector connector = new TestConnector(muleContext);
        muleContext.getRegistry().registerConnector((Connector)connector);
        Assert.assertEquals((long)ThreadingProfile.DEFAULT_MAX_THREADS_ACTIVE, (long)connector.getDispatcherThreadingProfile().getMaxThreadsActive());
        Assert.assertEquals((long)ThreadingProfile.DEFAULT_MAX_THREADS_IDLE, (long)connector.getDispatcherThreadingProfile().getMaxThreadsIdle());
        Assert.assertEquals((long)4L, (long)connector.getDispatcherThreadingProfile().getPoolExhaustedAction());
        Assert.assertEquals((long)ThreadingProfile.DEFAULT_MAX_BUFFER_SIZE, (long)connector.getDispatcherThreadingProfile().getMaxBufferSize());
        Assert.assertEquals((long)ThreadingProfile.DEFAULT_MAX_THREAD_TTL, (long)connector.getDispatcherThreadingProfile().getThreadTTL());
        Assert.assertEquals((long)ThreadingProfile.DEFAULT_THREAD_WAIT_TIMEOUT, (long)connector.getDispatcherThreadingProfile().getThreadWaitTimeout());
    }

    @Test
    public void testDefaultRunExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(2);
        this.createTestConnectorWithSingleDispatcherThread(4);
        this.dispatchTwoAsyncEvents();
        Assert.assertTrue((boolean)this.latch.await(WAIT_TIME, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testWaitExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(2);
        this.createTestConnectorWithSingleDispatcherThread(1, 0, ThreadingProfile.DEFAULT_THREAD_WAIT_TIMEOUT, ThreadingProfile.DEFAULT_MAX_BUFFER_SIZE);
        this.dispatchTwoAsyncEvents();
        Assert.assertTrue((boolean)this.latch.await(SERIAL_WAIT_TIME, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testWaitTimeoutExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(0);
        this.dispatchTwoAsyncEvents();
        new PollingProber(LONGER_WAIT_TIME, 50L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                Assert.assertEquals((long)0L, (long)DispatcherThreadingProfileTestCase.this.latch.getCount());
                return true;
            }
        });
    }

    @Test
    public void testAbortExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(3);
        this.dispatchTwoAsyncEvents();
        new PollingProber(LONGER_WAIT_TIME, 50L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                Assert.assertEquals((long)0L, (long)DispatcherThreadingProfileTestCase.this.latch.getCount());
                return true;
            }
        });
    }

    @Test
    public void testDiscardExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(1);
        this.dispatchTwoAsyncEvents();
        new PollingProber(LONGER_WAIT_TIME, 50L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                Assert.assertEquals((long)0L, (long)DispatcherThreadingProfileTestCase.this.latch.getCount());
                return true;
            }
        });
    }

    @Test
    public void testDiscardOldestExhaustedAction() throws Exception {
        this.latch = new CountDownLatch(3);
        this.createTestConnectorWithSingleDispatcherThread(2, 2, ThreadingProfile.DEFAULT_THREAD_WAIT_TIMEOUT, 1);
        this.dispatchTwoAsyncEvents();
        this.dispatchTwoAsyncEvents();
        this.dispatchTwoAsyncEvents();
        new PollingProber(LONGER_WAIT_TIME, 50L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                Assert.assertEquals((long)0L, (long)DispatcherThreadingProfileTestCase.this.latch.getCount());
                return true;
            }
        });
    }

    @Test
    public void testDiscardOldestExhaustedWithBufferQueueAction() throws Exception {
        this.latch = new CountDownLatch(1);
        this.createTestConnectorWithSingleDispatcherThread(1, 2, ThreadingProfile.DEFAULT_THREAD_WAIT_TIMEOUT, 0);
        this.dispatchTwoAsyncEvents();
        new PollingProber(LONGER_WAIT_TIME, 50L).check(new JUnitProbe(){

            @Override
            protected boolean test() throws Exception {
                Assert.assertEquals((long)0L, (long)DispatcherThreadingProfileTestCase.this.latch.getCount());
                return true;
            }
        });
    }

    protected void createTestConnectorWithSingleDispatcherThread(int exhaustedAction) throws MuleException {
        this.createTestConnectorWithSingleDispatcherThread(1, exhaustedAction, DELAY_TIME, 1);
    }

    protected void createTestConnectorWithSingleDispatcherThread(int threads, int exhaustedAction, long waitTimeout, int maxBufferSize) throws MuleException {
        TestConnector connector = new TestConnector(muleContext);
        ImmutableThreadingProfile threadingProfile = new ImmutableThreadingProfile(threads, threads, maxBufferSize, ThreadingProfile.DEFAULT_MAX_THREAD_TTL, waitTimeout, exhaustedAction, true, null, null);
        threadingProfile.setMuleContext(muleContext);
        connector.setDispatcherThreadingProfile((ThreadingProfile)threadingProfile);
        muleContext.getRegistry().registerConnector((Connector)connector);
        connector.setDispatcherFactory((MessageDispatcherFactory)new DelayTestMessageDispatcherFactory());
    }

    private void dispatchTwoAsyncEvents() throws Exception {
        OutboundEndpoint endpoint = muleContext.getEndpointFactory().getOutboundEndpoint("test://test");
        endpoint.process(DispatcherThreadingProfileTestCase.getTestEvent((Object)"data", DispatcherThreadingProfileTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY)));
        endpoint.process(DispatcherThreadingProfileTestCase.getTestEvent((Object)"data", DispatcherThreadingProfileTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY)));
    }

    class DelayTestMessageDispatcherFactory
    extends TestMessageDispatcherFactory {
        DelayTestMessageDispatcherFactory() {
        }

        @Override
        public MessageDispatcher create(OutboundEndpoint endpoint) throws MuleException {
            return new DelayTestMessageDispatcher(endpoint);
        }
    }

    public class DelayTestMessageDispatcher
    extends TestMessageDispatcher {
        public DelayTestMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        @Override
        protected void doDispatch(MuleEvent event) throws Exception {
            super.doDispatch(event);
            DispatcherThreadingProfileTestCase.this.latch.countDown();
        }
    }
}

