/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.io.IOException;
import java.net.URL;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.ws.security.cache.ReplayCacheFactory;
import org.apache.cxf.ws.security.tokenstore.EHCacheTokenStoreFactory;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStoreFactory;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

public abstract class TokenStoreFactory {
    private static boolean ehCacheInstalled;

    protected static synchronized boolean isEhCacheInstalled() {
        return ehCacheInstalled;
    }

    public static TokenStoreFactory newInstance() {
        if (TokenStoreFactory.isEhCacheInstalled()) {
            return new EHCacheTokenStoreFactory();
        }
        return new MemoryTokenStoreFactory();
    }

    public abstract TokenStore newTokenStore(String var1, Message var2);

    protected URL getConfigFileURL(Message message) {
        Object o = message.getContextualProperty("ws-security.cache.config.file");
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = (ResourceManager)message.getExchange().getBus().getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), ReplayCacheFactory.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException iOException) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    static {
        try {
            Class<?> cacheManagerClass = Class.forName("net.sf.ehcache.CacheManager");
            if (cacheManagerClass != null) {
                ehCacheInstalled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

