/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import javax.activation.MimetypesFileTypeMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.file.ReceiverFileInputStream;

public class FileMuleMessageFactory
extends AbstractMuleMessageFactory {
    private final MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{File.class, ReceiverFileInputStream.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        File file = this.convertToFile(transportMessage);
        this.setPropertiesFromFile((MuleMessage)message, file);
    }

    protected String getMimeType(Object transportMessage) {
        File file = this.convertToFile(transportMessage);
        return this.mimetypesFileTypeMap.getContentType(file.getName().toLowerCase());
    }

    protected File convertToFile(Object transportMessage) {
        File file = null;
        if (transportMessage instanceof File) {
            file = (File)transportMessage;
        } else if (transportMessage instanceof ReceiverFileInputStream) {
            file = ((ReceiverFileInputStream)transportMessage).getCurrentFile();
        }
        return file;
    }

    protected void setPropertiesFromFile(MuleMessage message, File file) {
        message.setProperty("originalFilename", (Object)file.getName(), PropertyScope.INBOUND);
        message.setProperty("directory", (Object)file.getParent(), PropertyScope.INBOUND);
        message.setProperty("fileSize", (Object)file.length(), PropertyScope.INBOUND);
        message.setProperty("timestamp", (Object)file.lastModified(), PropertyScope.INBOUND);
    }
}

