/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import org.mule.agent.AbstractNotificationLoggerAgent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.module.management.support.JmxSupport;
import org.mule.module.management.support.JmxSupportFactory;

public class JmxServerNotificationAgent
extends AbstractNotificationLoggerAgent {
    public static final String SERVER_NOTIFICATION_SOURCE_NAME = "Server Notification";
    public static final String LISTENER_JMX_OBJECT_NAME = "type=org.mule.Notification,name=MuleNotificationListener";
    public static final String BROADCASTER_JMX_OBJECT_NAME = "type=org.mule.Notification,name=MuleNotificationBroadcaster";
    public static final String DEFAULT_AGENT_NAME = "Jmx Notification Agent";
    private MBeanServer mBeanServer;
    private BroadcastNotificationService broadcastNotificationMbean;
    private boolean registerListenerMbean = true;
    private ObjectName listenerObjectName;
    private ObjectName broadcasterObjectName;
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport;

    public JmxServerNotificationAgent() {
        super(DEFAULT_AGENT_NAME);
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.jmxSupport = this.jmxSupportFactory.getJmxSupport();
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            this.broadcasterObjectName = ObjectName.getInstance(this.jmxSupport.getDomainName(this.muleContext) + ":" + BROADCASTER_JMX_OBJECT_NAME);
            this.broadcastNotificationMbean = new BroadcastNotificationService();
            this.mBeanServer.registerMBean(this.broadcastNotificationMbean, this.broadcasterObjectName);
            if (this.registerListenerMbean) {
                this.listenerObjectName = ObjectName.getInstance(this.jmxSupport.getDomainName(this.muleContext) + ":" + LISTENER_JMX_OBJECT_NAME);
                NotificationListener mbean = new NotificationListener();
                this.broadcastNotificationMbean.addNotificationListener(mbean, null, null);
                this.mBeanServer.registerMBean(mbean, this.listenerObjectName);
            }
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToStart((String)"JMX Server Notification Agent"), (Throwable)e, (Initialisable)this);
        }
    }

    public void dispose() {
        if (this.listenerObjectName != null && this.mBeanServer.isRegistered(this.listenerObjectName)) {
            try {
                this.mBeanServer.unregisterMBean(this.listenerObjectName);
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.broadcasterObjectName != null && this.mBeanServer.isRegistered(this.broadcasterObjectName)) {
            try {
                this.mBeanServer.unregisterMBean(this.broadcasterObjectName);
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        super.dispose();
    }

    protected void logEvent(ServerNotification e) {
        this.broadcastNotificationMbean.sendNotification(new Notification(e.getClass().getName(), (Object)SERVER_NOTIFICATION_SOURCE_NAME, e.getTimestamp(), e.toString()));
    }

    public String getDescription() {
        return DEFAULT_AGENT_NAME + (this.registerListenerMbean ? " (Listener MBean registered)" : "");
    }

    public JmxSupportFactory getJmxSupportFactory() {
        return this.jmxSupportFactory;
    }

    public void setJmxSupportFactory(JmxSupportFactory jmxSupportFactory) {
        this.jmxSupportFactory = jmxSupportFactory;
    }

    public static class NotificationListener
    implements NotificationListenerMBean,
    javax.management.NotificationListener {
        private int listSize = 100;
        private List<Notification> notifs;

        @Override
        public void handleNotification(Notification notification, Object o) {
            if (this.getList().size() == this.listSize) {
                this.getList().remove(this.listSize - 1);
            }
            this.getList().add(0, notification);
        }

        @Override
        public List<Notification> getNotificationsList() {
            return this.notifs;
        }

        @Override
        public int getListSize() {
            return this.listSize;
        }

        @Override
        public void setListSize(int listSize) {
            this.listSize = listSize;
        }

        protected List<Notification> getList() {
            if (this.notifs == null) {
                this.notifs = new ArrayList<Notification>(this.listSize);
            }
            return this.notifs;
        }
    }

    public static interface NotificationListenerMBean {
        public List<Notification> getNotificationsList();

        public int getListSize();

        public void setListSize(int var1);
    }

    public static class BroadcastNotificationService
    extends NotificationBroadcasterSupport
    implements BroadcastNotificationServiceMBean {
    }

    public static interface BroadcastNotificationServiceMBean
    extends NotificationEmitter {
    }
}

