/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.wsdl.http.AddressType;
import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.message.DefaultExceptionPayload;
import org.mule.module.cxf.HttpRequestPropertyManager;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.module.cxf.support.DelegatingOutputStream;
import org.mule.module.cxf.transport.MuleUniversalDestination;
import org.mule.module.http.internal.listener.properties.SSLSessionProperties;
import org.mule.module.xml.stax.StaxSource;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CxfInboundMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Lifecycle,
NonBlockingSupported {
    public static final String JMS_TRANSPORT = "jms";
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Bus bus;
    protected String transportClass;
    protected Server server;
    private boolean proxy;
    private QueryHandler wsdlQueryHandler;
    private String mimeType;

    public void initialise() throws InitialisationException {
        if (this.bus == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"No CXF bus instance, this component has not been initialized properly."), (Initialisable)this);
        }
    }

    public void stop() throws MuleException {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void start() throws MuleException {
        if (this.server != null) {
            this.server.start();
        }
    }

    public void dispose() {
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        String requestPath = this.parseHttpRequestProperty(HttpRequestPropertyManager.getRequestPath(event.getMessage()));
        try {
            if (requestPath.indexOf(63) > -1) {
                return this.generateWSDLOrXSD(event, requestPath);
            }
            return this.sendToDestination(event);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private String parseHttpRequestProperty(String request) {
        String uriBase = "";
        if (!request.contains("?wsdl") && !request.contains("?xsd")) {
            int qIdx = request.indexOf(63);
            if (qIdx > -1) {
                uriBase = request.substring(0, qIdx);
            }
        } else {
            uriBase = request;
        }
        return uriBase;
    }

    protected MuleEvent generateWSDLOrXSD(MuleEvent event, String req) throws EndpointNotFoundException, IOException {
        String msg;
        String ctxUri = (String)event.getMessage().getInboundProperty("http.context.path");
        String wsdlUri = this.getUri(event);
        String serviceUri = wsdlUri.substring(0, wsdlUri.indexOf(63));
        EndpointInfo ei = this.getServer().getEndpoint().getEndpointInfo();
        if (serviceUri != null) {
            ei.setAddress(serviceUri);
            if (ei.getExtensor(AddressType.class) != null) {
                ((AddressType)ei.getExtensor(AddressType.class)).setLocation(serviceUri);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String ct = null;
        if (this.wsdlQueryHandler.isRecognizedQuery(wsdlUri, ctxUri, ei)) {
            ct = this.wsdlQueryHandler.getResponseContentType(wsdlUri, ctxUri);
            this.wsdlQueryHandler.writeResponse(wsdlUri, ctxUri, ei, (OutputStream)out);
            out.flush();
        }
        if (ct == null) {
            ct = "text/plain";
            msg = "No query handler found for URL.";
        } else {
            msg = out.toString();
        }
        event.getMessage().setPayload((Object)msg, DataTypeFactory.XML_STRING);
        event.getMessage().setOutboundProperty("Content-Type", (Object)ct);
        return event;
    }

    private String getUri(MuleEvent event) {
        String scheme = HttpRequestPropertyManager.getScheme(event);
        String host = (String)event.getMessage().getInboundProperty("Host");
        String ctx = HttpRequestPropertyManager.getRequestPath(event.getMessage());
        return scheme + "://" + host + ctx;
    }

    protected MuleEvent sendToDestination(MuleEvent event) throws MuleException, IOException {
        try {
            MuleEvent responseEvent;
            ExchangeImpl exchange = new ExchangeImpl();
            MuleEvent originalEvent = event;
            if (event.isAllowNonBlocking()) {
                ReplyToHandler originalReplyToHandler = event.getReplyToHandler();
                event = new DefaultMuleEvent(event, (ReplyToHandler)new NonBlockingReplyToHandler((Exchange)exchange, originalEvent, originalReplyToHandler){
                    final /* synthetic */ Exchange val$exchange;
                    final /* synthetic */ MuleEvent val$originalEvent;
                    final /* synthetic */ ReplyToHandler val$originalReplyToHandler;
                    {
                        this.val$exchange = exchange;
                        this.val$originalEvent = muleEvent;
                        this.val$originalReplyToHandler = replyToHandler;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void processReplyTo(MuleEvent responseEvent, MuleMessage returnMessage, Object replyTo) throws MuleException {
                        try {
                            CountDownLatch countDownLatch = (CountDownLatch)this.val$exchange.get((Object)"NON_BLOCKING_LATCH");
                            countDownLatch.await(1000L, TimeUnit.SECONDS);
                            this.val$exchange.put((Object)"mule.event", (Object)responseEvent);
                            this.val$exchange.put((Object)"mule.nonBlockingResponse", (Object)true);
                            this.val$exchange.getInMessage().getInterceptorChain().resume();
                            responseEvent = (MuleEvent)this.val$exchange.get((Object)"mule.event");
                            responseEvent = CxfInboundMessageProcessor.this.processResponse(this.val$originalEvent, this.val$exchange, responseEvent);
                            this.val$originalReplyToHandler.processReplyTo(responseEvent, responseEvent.getMessage(), replyTo);
                        }
                        catch (Exception e) {
                            DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload((Throwable)e);
                            responseEvent.getMessage().setExceptionPayload((ExceptionPayload)exceptionPayload);
                            returnMessage.setOutboundProperty("http.status", (Object)500);
                            responseEvent.setMessage(returnMessage);
                            this.processExceptionReplyTo(new MessagingException(responseEvent, (Throwable)e, (MessageProcessor)CxfInboundMessageProcessor.this), replyTo);
                        }
                        finally {
                            this.val$exchange.put((Object)"NON_BLOCKING_LATCH", (Object)new CountDownLatch(1));
                        }
                    }

                    public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                        this.val$originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                    }
                });
                OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            }
            if ((responseEvent = this.sendThroughCxf(event, (Exchange)exchange)) == null || !responseEvent.equals(NonBlockingVoidMuleEvent.getInstance())) {
                return this.processResponse(event, (Exchange)exchange, responseEvent);
            }
            return responseEvent;
        }
        catch (MuleException e) {
            this.logger.warn((Object)"Could not dispatch message to CXF!", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleEvent sendThroughCxf(MuleEvent event, Exchange exchange) throws TransformerException, IOException {
        Destination d;
        String path;
        MessageImpl m = new MessageImpl();
        m.setExchange(exchange);
        MuleMessage muleReqMsg = event.getMessage();
        if (muleReqMsg.getInboundProperty("http.ssl.session") != null) {
            SSLSessionProperties sessionProperties = (SSLSessionProperties)muleReqMsg.getInboundProperty("http.ssl.session");
            SSLSession session = sessionProperties.retrieveSession();
            TLSSessionInfo tlsinfo = new TLSSessionInfo(session.getCipherSuite(), session, session.getLocalCertificates());
            m.put(TLSSessionInfo.class, (Object)tlsinfo);
        }
        String method = (String)muleReqMsg.getInboundProperty("http.method");
        String ct = (String)muleReqMsg.getInboundProperty("Content-Type");
        if (ct != null) {
            m.put("Content-Type", (Object)ct);
        }
        if ((path = (String)muleReqMsg.getInboundProperty("http.request.path")) == null) {
            path = "";
        }
        if (method != null) {
            m.put("org.apache.cxf.request.method", (Object)method);
            m.put(Message.PATH_INFO, (Object)path);
            String basePath = HttpRequestPropertyManager.getBasePath(muleReqMsg);
            m.put(Message.BASE_PATH, (Object)basePath);
            method = method.toUpperCase();
        }
        if (!"GET".equals(method)) {
            Object payload = event.getMessage().getPayload();
            this.setPayload(event, m, payload);
        }
        String soapAction = this.getSoapAction(event.getMessage());
        m.put("SOAPAction", (Object)soapAction);
        if (this.server != null) {
            d = this.server.getDestination();
        } else {
            String serviceUri = this.getUri(event);
            DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
            DestinationFactory df = dfm.getDestinationFactoryForUri(serviceUri);
            EndpointInfo ei = new EndpointInfo();
            ei.setAddress(serviceUri);
            d = df.getDestination(ei);
        }
        if (this.shouldSoapActionHeader()) {
            String eventRequestUri;
            HashMap<String, List<Object>> protocolHeaders = new HashMap<String, List<Object>>();
            if (soapAction != null && !soapAction.isEmpty()) {
                ArrayList<String> soapActions = new ArrayList<String>();
                soapActions.add(soapAction);
                protocolHeaders.put("SOAPAction", soapActions);
            }
            if ((eventRequestUri = event.getMessageSourceURI().toString()).startsWith(JMS_TRANSPORT) || "http://www.w3.org/2010/soapjms/".equals(((MuleUniversalDestination)d).getEndpointInfo().getTransportId())) {
                String contentType = (String)muleReqMsg.getInboundProperty("SOAPJMS_contentType");
                if (contentType == null) {
                    contentType = "text/xml";
                }
                protocolHeaders.put("SOAPJMS_contentType", Collections.singletonList(contentType));
                String requestUri = (String)muleReqMsg.getInboundProperty("SOAPJMS_requestURI");
                if (requestUri == null) {
                    requestUri = eventRequestUri;
                }
                protocolHeaders.put("SOAPJMS_requestURI", Collections.singletonList(requestUri));
            }
            m.put(Message.PROTOCOL_HEADERS, protocolHeaders);
        }
        m.put(LocalConduit.DIRECT_DISPATCH, (Object)Boolean.TRUE);
        m.setDestination(d);
        exchange.put((Object)StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        exchange.setInMessage((Message)m);
        exchange.put((Object)"mule.event", (Object)event);
        try {
            d.getMessageObserver().onMessage((Message)m);
        }
        catch (SuspendedInvocationException e) {
            MuleEvent responseEvent = (MuleEvent)exchange.get((Object)"mule.event");
            if (responseEvent == null || !responseEvent.equals(NonBlockingVoidMuleEvent.getInstance())) {
                throw e;
            }
            CountDownLatch nonBlockingLatch = (CountDownLatch)exchange.get((Object)"NON_BLOCKING_LATCH");
            nonBlockingLatch.countDown();
        }
        finally {
            CxfUtils.clearClientContextIfNeeded(d.getMessageObserver());
        }
        return (MuleEvent)exchange.get((Object)"mule.event");
    }

    private MuleEvent processResponse(MuleEvent event, Exchange exchange, MuleEvent responseEvent) {
        if (responseEvent == null || VoidMuleEvent.getInstance().equals(responseEvent) || !event.getExchangePattern().hasResponse()) {
            return null;
        }
        MuleMessage muleResMsg = responseEvent.getMessage();
        BindingOperationInfo binding = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (null != binding && null != binding.getOperationInfo() && binding.getOperationInfo().isOneWay()) {
            muleResMsg.setOutboundProperty("http.status", (Object)202);
            muleResMsg.setPayload((Object)NullPayload.getInstance());
        } else {
            muleResMsg.setPayload((Object)this.getResponseOutputHandler(exchange), DataTypeFactory.XML_STRING);
        }
        Message faultMsg = exchange.getOutFaultMessage();
        if (faultMsg != null) {
            Exception ex;
            if (null != binding && null != binding.getOperationInfo() && binding.getOperationInfo().isOneWay()) {
                muleResMsg.setPayload((Object)this.getResponseOutputHandler(exchange), DataTypeFactory.XML_STRING);
            }
            if ((ex = (Exception)faultMsg.getContent(Exception.class)) != null) {
                DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload((Throwable)ex);
                event.getMessage().setExceptionPayload((ExceptionPayload)exceptionPayload);
                muleResMsg.setOutboundProperty("http.status", (Object)500);
            }
        }
        return responseEvent;
    }

    protected boolean shouldSoapActionHeader() {
        boolean isGenericProxy = "http://support.cxf.module.mule.org/".equals(this.getServer().getEndpoint().getService().getName().getNamespaceURI()) && "ProxyService".equals(this.getServer().getEndpoint().getService().getName().getLocalPart());
        return !isGenericProxy;
    }

    public MuleEvent processNext(MuleEvent event) throws MuleException {
        return super.processNext(event);
    }

    @Deprecated
    protected OutputHandler getRessponseOutputHandler(MessageImpl m) {
        return this.getResponseOutputHandler(m);
    }

    protected OutputHandler getResponseOutputHandler(MessageImpl m) {
        return this.getResponseOutputHandler(m.getExchange());
    }

    protected OutputHandler getResponseOutputHandler(final Exchange exchange) {
        OutputHandler outputHandler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                Message outFaultMessage = exchange.getOutFaultMessage();
                Message outMessage = exchange.getOutMessage();
                Message contentMsg = null;
                if (outFaultMessage != null && outFaultMessage.getContent(OutputStream.class) != null) {
                    contentMsg = outFaultMessage;
                } else if (outMessage != null) {
                    contentMsg = outMessage;
                }
                if (contentMsg == null) {
                    return;
                }
                DelegatingOutputStream delegate = (DelegatingOutputStream)contentMsg.getContent(DelegatingOutputStream.class);
                if (delegate.getOutputStream() instanceof ByteArrayOutputStream) {
                    out.write(((ByteArrayOutputStream)delegate.getOutputStream()).toByteArray());
                }
                delegate.setOutputStream(out);
                out.flush();
                contentMsg.getInterceptorChain().resume();
            }
        };
        return outputHandler;
    }

    private void setPayload(MuleEvent ctx, MessageImpl m, Object payload) throws TransformerException {
        if (payload instanceof InputStream) {
            m.put(Message.ENCODING, (Object)ctx.getEncoding());
            m.setContent(InputStream.class, payload);
        } else if (payload instanceof Reader) {
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Reader)((Reader)payload)));
        } else if (payload instanceof byte[]) {
            m.setContent(InputStream.class, (Object)new ByteArrayInputStream((byte[])payload));
        } else if (payload instanceof StaxSource) {
            m.setContent(XMLStreamReader.class, (Object)((StaxSource)payload).getXMLStreamReader());
        } else if (payload instanceof Source) {
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Source)((Source)payload)));
        } else if (payload instanceof XMLStreamReader) {
            m.setContent(XMLStreamReader.class, payload);
        } else if (payload instanceof Document) {
            DOMSource source = new DOMSource((Node)payload);
            m.setContent(XMLStreamReader.class, (Object)StaxUtils.createXMLStreamReader((Source)source));
        } else {
            InputStream is = (InputStream)ctx.transformMessage(DataTypeFactory.create(InputStream.class));
            m.put(Message.ENCODING, (Object)ctx.getEncoding());
            m.setContent(InputStream.class, (Object)is);
        }
    }

    protected InputStream getMessageStream(MuleEvent context) throws MuleException {
        Object eventMsgPayload = context.getMessage().getPayload();
        InputStream is = eventMsgPayload instanceof InputStream ? (InputStream)eventMsgPayload : (InputStream)context.transformMessage(DataTypeFactory.create(InputStream.class));
        return is;
    }

    protected String getSoapAction(MuleMessage message) {
        String action = (String)message.getInboundProperty("soapAction");
        if (action != null && action.startsWith("\"") && action.endsWith("\"") && action.length() >= 2) {
            action = action.substring(1, action.length() - 1);
        }
        return action;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setWSDLQueryHandler(QueryHandler wsdlQueryHandler) {
        this.wsdlQueryHandler = wsdlQueryHandler;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

