/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.MessageObserver;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointNotFoundException;

public final class CxfUtils {
    public static void clearClientContextIfNeeded(MessageObserver client) {
        if (client instanceof ClientImpl) {
            ((ClientImpl)client).getRequestContext().clear();
            ((ClientImpl)client).getResponseContext().clear();
        }
    }

    public static boolean removeInterceptor(List<Interceptor<? extends Message>> inInterceptors, String name) {
        for (Interceptor<? extends Message> i : inInterceptors) {
            PhaseInterceptor p;
            if (!(i instanceof PhaseInterceptor) || !(p = (PhaseInterceptor)i).getId().equals(name)) continue;
            inInterceptors.remove(p);
            return true;
        }
        return false;
    }

    public static boolean interceptorOfClassIsPresent(List<Interceptor<? extends Message>> interceptors, Class interceptorClass) {
        for (Interceptor<? extends Message> interceptor : interceptors) {
            if (!interceptor.getClass().equals(interceptorClass)) continue;
            return true;
        }
        return false;
    }

    public static Endpoint getEndpoint(DestinationFactory df, String uri) throws IOException, EndpointNotFoundException {
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(uri);
        Destination d = df.getDestination(ei);
        if (d.getMessageObserver() == null) {
            throw new EndpointNotFoundException(uri);
        }
        MessageObserver mo = d.getMessageObserver();
        if (!(mo instanceof ChainInitiationObserver)) {
            throw new EndpointNotFoundException(uri);
        }
        ChainInitiationObserver co = (ChainInitiationObserver)mo;
        return co.getEndpoint();
    }

    public static String getBindingIdForSoapVersion(String version) {
        Iterator soapVersions = SoapVersionFactory.getInstance().getVersions();
        while (soapVersions.hasNext()) {
            SoapVersion soapVersion = (SoapVersion)soapVersions.next();
            if (!Double.toString(soapVersion.getVersion()).equals(version)) continue;
            return soapVersion.getBindingId();
        }
        throw new IllegalArgumentException("Invalid Soap version " + version);
    }

    public static String mapUnsupportedSchemas(String url) {
        if (url != null) {
            url = url.replace("servlet://", "http://");
            url = url.replace("jetty://", "http://");
            url = url.replace("jetty-ssl://", "https://");
        }
        return url;
    }

    public static String resolveEncoding(MuleMessage result, String contentType) {
        MediaType mediaType = MediaType.parse((String)contentType);
        return mediaType.charset().isPresent() ? ((Charset)mediaType.charset().get()).name() : result.getEncoding();
    }
}

