/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.policies;

import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.api.retry.RetryNotifier;
import org.mule.api.retry.RetryPolicy;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.management.stats.AllStatistics;
import org.mule.retry.DefaultRetryContext;
import org.mule.retry.PolicyStatus;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.retry.notifiers.ConnectNotifier;

public abstract class AbstractPolicyTemplate
implements RetryPolicyTemplate,
MuleContextAware {
    protected RetryNotifier notifier = new ConnectNotifier();
    private Map<Object, Object> metaInfo;
    private MuleContext muleContext;
    private AtomicBoolean stopRetrying = new AtomicBoolean(false);
    private volatile boolean lastRetryInterrupted = false;
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public RetryContext execute(RetryCallback callback, WorkManager workManager) throws Exception {
        PolicyStatus status = null;
        RetryPolicy policy = this.createRetryInstance();
        DefaultRetryContext context = new DefaultRetryContext(callback.getWorkDescription(), this.metaInfo);
        context.setMuleContext(this.muleContext);
        try {
            Exception cause = null;
            while (true) {
                try {
                    callback.doWork(context);
                    if (this.notifier != null) {
                        this.notifier.onSuccess(context);
                    }
                    if (!this.lastRetryInterrupted) break;
                    this.logger.info((Object)("Successfully connected to " + context.getDescription() + " after Interrupted IOException"));
                    this.lastRetryInterrupted = false;
                }
                catch (Exception e) {
                    cause = e;
                    AllStatistics statistics = this.muleContext.getStatistics();
                    if (statistics != null && statistics.isEnabled()) {
                        statistics.getApplicationStatistics().incConnectionErrors();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)cause);
                    }
                    if (this.notifier != null) {
                        this.notifier.onFailure(context, cause);
                    }
                    if (!(cause instanceof InterruptedException) && !(cause instanceof InterruptedIOException)) continue;
                    this.logger.error((Object)"Process was interrupted (InterruptedException), ceasing process");
                    this.lastRetryInterrupted = true;
                    break;
                    if ((status = policy.applyPolicy(cause)).isOk() && !this.stopRetrying.get()) continue;
                }
                break;
            }
            context.setFailed(cause);
            if (status == null || status.isOk()) {
                DefaultRetryContext defaultRetryContext = context;
                return defaultRetryContext;
            }
            throw new RetryPolicyExhaustedException(cause, callback.getWorkOwner());
        }
        finally {
            if (status != null && status.getThrowable() != null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)status.getThrowable());
            }
        }
    }

    @Override
    public RetryNotifier getNotifier() {
        return this.notifier;
    }

    @Override
    public void setNotifier(RetryNotifier retryNotifier) {
        this.notifier = retryNotifier;
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void setMetaInfo(Map<Object, Object> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setId(String id) {
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    protected AtomicBoolean isStopRetrying() {
        return this.stopRetrying;
    }

    @Override
    public void stopRetrying() {
        this.stopRetrying.compareAndSet(false, true);
    }
}

