/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.message.DefaultExceptionPayload;
import org.mule.retry.RetryPolicyExhaustedException;
import org.mule.routing.AbstractUntilSuccessfulProcessingStrategy;
import org.mule.util.Preconditions;
import org.mule.util.concurrent.ThreadNameHelper;
import org.mule.util.queue.objectstore.QueueKey;

public class AsynchronousUntilSuccessfulProcessingStrategy
extends AbstractUntilSuccessfulProcessingStrategy
implements Initialisable,
Disposable,
Startable,
Stoppable,
MessagingExceptionHandlerAware {
    private static final String UNTIL_SUCCESSFUL_MSG_PREFIX = "until-successful retries exhausted. Last exception message was: %s";
    private static final Random random = new Random();
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private MessagingExceptionHandler messagingExceptionHandler;
    private ExecutorService pool;
    private ScheduledExecutorService scheduledRetriesPool;
    private MuleContextNotificationListener<MuleContextNotification> contextStartListener;
    private final MuleContext muleContext;

    public AsynchronousUntilSuccessfulProcessingStrategy(MuleContext muleContext) {
        Preconditions.checkArgument(muleContext != null, "muleContext cannot be null");
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.getUntilSuccessfulConfiguration().getObjectStore() == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("A ListableObjectStore must be configured on UntilSuccessful."), (Initialisable)this);
        }
        this.contextStartListener = new MuleContextNotificationListener<MuleContextNotification>(){

            @Override
            public void onNotification(MuleContextNotification notification) {
                if (notification.getAction() == 104) {
                    AsynchronousUntilSuccessfulProcessingStrategy.this.muleContext.unregisterListener(this);
                    AsynchronousUntilSuccessfulProcessingStrategy.this.contextStartListener = null;
                    AsynchronousUntilSuccessfulProcessingStrategy.this.scheduleAllPendingEventsForProcessing();
                }
            }
        };
        try {
            this.muleContext.registerListener(this.contextStartListener);
        }
        catch (NotificationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public void start() {
        String threadPrefix = String.format("%s%s.%s", ThreadNameHelper.getPrefix(this.getUntilSuccessfulConfiguration().getMuleContext()), this.getUntilSuccessfulConfiguration().getFlowConstruct().getName(), "until-successful");
        this.pool = this.getUntilSuccessfulConfiguration().getThreadingProfile().createPool(threadPrefix);
        this.scheduledRetriesPool = this.getUntilSuccessfulConfiguration().createScheduledRetriesPool(threadPrefix);
    }

    @Override
    public void stop() {
        this.scheduledRetriesPool.shutdown();
        this.scheduledRetriesPool = null;
        this.pool.shutdown();
        this.pool = null;
    }

    @Override
    protected MuleEvent doRoute(MuleEvent event) throws MessagingException {
        try {
            Serializable eventStoreKey = this.storeEvent(event);
            this.scheduleForProcessing(eventStoreKey, true);
            if (this.getUntilSuccessfulConfiguration().getAckExpression() == null) {
                return VoidMuleEvent.getInstance();
            }
            return this.processResponseThroughAckResponseExpression(event);
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage("Failed to schedule the event for processing"), event, e, this.getUntilSuccessfulConfiguration().getRouter());
        }
    }

    private void scheduleAllPendingEventsForProcessing() {
        block5: {
            try {
                for (Serializable eventStoreKey : this.getUntilSuccessfulConfiguration().getObjectStore().allKeys()) {
                    try {
                        this.scheduleForProcessing(eventStoreKey, true);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)MessageFactory.createStaticMessage("Failed to schedule for processing event stored with key: " + eventStoreKey), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failure during scheduling of until successful previous jobs " + e.getMessage()));
                if (!this.logger.isDebugEnabled()) break block5;
                this.logger.debug((Object)e);
            }
        }
    }

    private void scheduleForProcessing(final Serializable eventStoreKey, boolean firstTime) {
        if (firstTime) {
            this.submitForProcessing(eventStoreKey);
        } else {
            this.scheduledRetriesPool.schedule(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AsynchronousUntilSuccessfulProcessingStrategy.this.submitForProcessing(eventStoreKey);
                    return null;
                }
            }, this.getUntilSuccessfulConfiguration().getMillisBetweenRetries(), TimeUnit.MILLISECONDS);
        }
    }

    protected void submitForProcessing(final Serializable eventStoreKey) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AsynchronousUntilSuccessfulProcessingStrategy.this.retrieveAndProcessEvent(eventStoreKey);
                }
                catch (ObjectStoreException ose) {
                    throw new MuleRuntimeException(ose);
                }
                catch (Exception e) {
                    AsynchronousUntilSuccessfulProcessingStrategy.this.incrementProcessAttemptCountAndRescheduleOrRemoveFromStore(eventStoreKey, e);
                }
            }
        });
    }

    private void incrementProcessAttemptCountAndRescheduleOrRemoveFromStore(Serializable eventStoreKey, Exception lastException) {
        try {
            MuleEvent event = (MuleEvent)this.getUntilSuccessfulConfiguration().getObjectStore().remove(eventStoreKey);
            MuleEvent mutableEvent = this.threadSafeCopy(event);
            MuleMessage message = mutableEvent.getMessage();
            Integer deliveryAttemptCount = message.getInvocationProperty("process.attempt.count", 1);
            if (deliveryAttemptCount <= this.getUntilSuccessfulConfiguration().getMaxRetries()) {
                message.setInvocationProperty("process.attempt.count", deliveryAttemptCount + 1);
                this.getUntilSuccessfulConfiguration().getObjectStore().store(eventStoreKey, mutableEvent);
                this.scheduleForProcessing(eventStoreKey, false);
            } else {
                this.abandonRetries(event, mutableEvent, lastException);
            }
        }
        catch (ObjectStoreException ose) {
            this.logger.error((Object)("Failed to increment failure count for event stored with key: " + eventStoreKey), (Throwable)ose);
        }
    }

    private Serializable storeEvent(MuleEvent event) throws ObjectStoreException {
        MuleMessage message = event.getMessage();
        Integer deliveryAttemptCount = message.getInvocationProperty("process.attempt.count", 1);
        return this.storeEvent(event, deliveryAttemptCount);
    }

    private Serializable storeEvent(MuleEvent event, int deliveryAttemptCount) throws ObjectStoreException {
        MuleMessage message = event.getMessage();
        message.setInvocationProperty("process.attempt.count", deliveryAttemptCount);
        Serializable eventStoreKey = AsynchronousUntilSuccessfulProcessingStrategy.buildQueueKey(event);
        this.getUntilSuccessfulConfiguration().getObjectStore().store(eventStoreKey, event);
        return eventStoreKey;
    }

    public static Serializable buildQueueKey(MuleEvent muleEvent) {
        String key = String.format("%s-%s-%s-%d", muleEvent.getFlowConstruct(), muleEvent.getMuleContext().getClusterId(), muleEvent.getId(), random.nextInt());
        return new QueueKey("queuestore", (Serializable)((Object)key));
    }

    private void abandonRetries(MuleEvent event, MuleEvent mutableEvent, Exception lastException) {
        if (this.getUntilSuccessfulConfiguration().getDlqMP() == null) {
            this.logger.info((Object)"Retry attempts exhausted and no DLQ defined");
            this.messagingExceptionHandler.handleException(this.buildRetryPolicyExhaustedException(lastException), mutableEvent);
            return;
        }
        MuleEvent eventCopy = this.threadSafeCopy(event);
        this.logger.info((Object)("Retry attempts exhausted, routing message to DLQ: " + this.getUntilSuccessfulConfiguration().getDlqMP()));
        try {
            mutableEvent.getMessage().setExceptionPayload(new DefaultExceptionPayload(this.buildRetryPolicyExhaustedException(lastException)));
            this.getUntilSuccessfulConfiguration().getDlqMP().process(mutableEvent);
        }
        catch (MessagingException e) {
            this.messagingExceptionHandler.handleException(e, eventCopy);
        }
        catch (Exception e) {
            this.messagingExceptionHandler.handleException(new MessagingException(event, (Throwable)e), eventCopy);
        }
    }

    protected RetryPolicyExhaustedException buildRetryPolicyExhaustedException(Exception e) {
        MuleException muleException = ExceptionHelper.getRootMuleException(e);
        if (muleException == null) {
            return new RetryPolicyExhaustedException(CoreMessages.createStaticMessage(UNTIL_SUCCESSFUL_MSG_PREFIX, e.getMessage()), e, this);
        }
        if (muleException.getCause() != null) {
            RetryPolicyExhaustedException retryPolicyExhaustedException = new RetryPolicyExhaustedException(CoreMessages.createStaticMessage(UNTIL_SUCCESSFUL_MSG_PREFIX, muleException.getMessage()), (Object)muleException.getCause());
            retryPolicyExhaustedException.getInfo().putAll(muleException.getInfo());
            return retryPolicyExhaustedException;
        }
        RetryPolicyExhaustedException retryPolicyExhaustedException = new RetryPolicyExhaustedException(CoreMessages.createStaticMessage(UNTIL_SUCCESSFUL_MSG_PREFIX, muleException.getMessage()), (Object)muleException);
        retryPolicyExhaustedException.getInfo().putAll(muleException.getInfo());
        return retryPolicyExhaustedException;
    }

    private void removeFromStore(Serializable eventStoreKey) {
        try {
            this.getUntilSuccessfulConfiguration().getObjectStore().remove(eventStoreKey);
        }
        catch (ObjectStoreException ose) {
            this.logger.warn((Object)("Failed to remove following event from store with key: " + eventStoreKey));
        }
    }

    private void retrieveAndProcessEvent(Serializable eventStoreKey) throws ObjectStoreException {
        MuleEvent persistedEvent = (MuleEvent)this.getUntilSuccessfulConfiguration().getObjectStore().retrieve(eventStoreKey);
        MuleEvent mutableEvent = this.threadSafeCopy(persistedEvent);
        try {
            this.processEvent(mutableEvent);
        }
        catch (Throwable e) {
            this.closeRetryPayload(mutableEvent.getMessage().getPayload(), mutableEvent.getMuleContext());
            throw e;
        }
        this.removeFromStore(eventStoreKey);
    }

    protected MuleEvent threadSafeCopy(MuleEvent event) {
        DefaultMuleMessage message = new DefaultMuleMessage(event.getMessage().getPayload(), event.getMessage(), this.getUntilSuccessfulConfiguration().getMuleContext());
        return new DefaultMuleEvent(message, event);
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    @Override
    public void dispose() {
        if (this.contextStartListener != null) {
            this.muleContext.unregisterListener(this.contextStartListener);
        }
    }
}

