/*
 * Decompiled with CFR 0.152.
 */
package org.mule.serialization.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.serialization.internal.JavaObjectSerializer;
import org.mule.util.ObjectInputStreamProvider;
import org.mule.util.Preconditions;
import org.mule.util.SerializationUtils;

public class ClassSpecificObjectSerializer
extends JavaObjectSerializer {
    private Class classToAccept;

    public ClassSpecificObjectSerializer(ObjectSerializer baseSerializer, Class classToAccept) {
        super(baseSerializer);
        this.classToAccept = classToAccept;
    }

    @Override
    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Preconditions.checkArgument(inputStream != null, "Cannot deserialize a null stream");
        Preconditions.checkArgument(classLoader != null, "Cannot deserialize with a null classloader");
        return (T)SerializationUtils.deserialize(inputStream, classLoader, this.muleContext, new ObjectInputStreamProvider(){

            @Override
            public ObjectInputStream get(ClassLoader classLoader, InputStream inputStream) throws IOException {
                return new ClassSpecificObjectInputStream(classLoader, inputStream, ClassSpecificObjectSerializer.this.classToAccept);
            }
        });
    }

    private static class ClassSpecificObjectInputStream
    extends ClassLoaderObjectInputStream {
        private Class classToAccept;
        private boolean firstClass = true;

        public ClassSpecificObjectInputStream(ClassLoader classLoader, InputStream inputStream, Class classToAccept) throws IOException, StreamCorruptedException {
            super(classLoader, inputStream);
            this.classToAccept = classToAccept;
        }

        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            Class resolved = super.resolveClass(objectStreamClass);
            if (!this.firstClass) {
                return resolved;
            }
            if (this.classToAccept.equals(resolved)) {
                this.firstClass = false;
                return resolved;
            }
            throw new InvalidClassException(String.format("Expecting an instance of '%s' but '%s' found", this.classToAccept.getName(), resolved.getName()));
        }
    }
}

