/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.MessageFormat;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;
import org.mule.util.StringUtils;

public abstract class AbstractAddVariablePropertyTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator identifierEvaluator;
    private AttributeEvaluator valueEvaluator;

    public AbstractAddVariablePropertyTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.identifierEvaluator.initialize(this.muleContext.getExpressionManager());
        this.valueEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String key;
        Object keyValue = this.identifierEvaluator.resolveValue(message);
        String string = key = keyValue == null ? null : keyValue.toString();
        if (key == null) {
            this.logger.error((Object)"Setting Null variable keys is not supported, this entry is being ignored");
        } else {
            TypedValue typedValue = this.valueEvaluator.resolveTypedValue(message);
            if (typedValue.getValue() == null || typedValue.getValue() instanceof NullPayload) {
                message.removeProperty(key, this.getScope());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)MessageFormat.format("Variable with key \"{0}\", not found on message using \"{1}\". Since the value was marked optional, nothing was set on the message for this variable", key, this.valueEvaluator.getRawValue()));
                }
            } else if (!StringUtils.isEmpty((String)this.mimeType) || !StringUtils.isEmpty((String)this.encoding)) {
                DataType<?> dataType = DataTypeFactory.create(typedValue.getValue().getClass(), this.getMimeType());
                dataType.setEncoding(this.getEncoding());
                message.setProperty(key, typedValue.getValue(), this.getScope(), dataType);
            } else {
                message.setProperty(key, typedValue.getValue(), this.getScope(), typedValue.getDataType());
            }
        }
        return message;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractAddVariablePropertyTransformer clone = (AbstractAddVariablePropertyTransformer)super.clone();
        clone.setIdentifier(this.identifierEvaluator.getRawValue());
        clone.setValue(this.valueEvaluator.getRawValue());
        return clone;
    }

    public void setIdentifier(String identifier) {
        if (StringUtils.isBlank((String)identifier)) {
            throw new IllegalArgumentException("Key cannot be blank");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier);
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        this.valueEvaluator = new AttributeEvaluator(value);
    }

    protected abstract PropertyScope getScope();
}

