/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xa;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.CollectionUtils;
import org.mule.util.journal.queue.XaQueueTxJournalEntry;
import org.mule.util.journal.queue.XaTxQueueTransactionJournal;
import org.mule.util.queue.PersistentXaTransactionContext;
import org.mule.util.queue.QueueProvider;
import org.mule.util.xa.ResourceManagerException;

public class XaTransactionRecoverer {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final XaTxQueueTransactionJournal xaTxQueueTransactionJournal;
    private final QueueProvider queueProvider;

    public XaTransactionRecoverer(XaTxQueueTransactionJournal xaTxQueueTransactionJournal, QueueProvider queueProvider) {
        this.xaTxQueueTransactionJournal = xaTxQueueTransactionJournal;
        this.queueProvider = queueProvider;
    }

    public XaTxQueueTransactionJournal getXaTxQueueTransactionJournal() {
        return this.xaTxQueueTransactionJournal;
    }

    public synchronized Xid[] recover(int flag) throws XAException {
        if (flag == 0x800000) {
            return new Xid[0];
        }
        Multimap xidXaJournalEntryMultimap = this.xaTxQueueTransactionJournal.getAllLogEntries();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Executing XA recover");
            this.logger.debug((Object)("Found " + xidXaJournalEntryMultimap.size() + " in the tx log"));
        }
        ArrayList<Xid> txsToRecover = new ArrayList<Xid>();
        for (Xid xid : xidXaJournalEntryMultimap.keySet()) {
            Collection entries = xidXaJournalEntryMultimap.get((Object)xid);
            Object commitOrRollback = CollectionUtils.find((Collection)entries, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    XaQueueTxJournalEntry logEntry = (XaQueueTxJournalEntry)object;
                    return logEntry.isCommit() || logEntry.isRollback();
                }
            });
            if (commitOrRollback != null) continue;
            txsToRecover.add(xid);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("found " + txsToRecover.size() + " txs to recover"));
        }
        return txsToRecover.toArray(new Xid[txsToRecover.size()]);
    }

    public void rollbackDandlingTransaction(Xid xid) throws XAException {
        try {
            this.logger.info((Object)("Rollbacking danling tx with id " + xid));
            new PersistentXaTransactionContext(this.xaTxQueueTransactionJournal, this.queueProvider, xid).doRollback();
        }
        catch (ResourceManagerException e) {
            this.logger.warn((Object)e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            throw new XAException(-4);
        }
    }

    public void commitDandlingTransaction(Xid xid, boolean onePhase) throws XAException {
        try {
            this.logger.info((Object)("Commiting danling tx with id " + xid));
            new PersistentXaTransactionContext(this.xaTxQueueTransactionJournal, this.queueProvider, xid).doCommit();
        }
        catch (ResourceManagerException e) {
            this.logger.warn((Object)e.getMessage());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            throw new XAException(-4);
        }
    }
}

