/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.MultiProducer;
import reactor.core.Scannable;
import reactor.core.Trackable;
import reactor.core.publisher.BlockingSink;
import reactor.core.publisher.DelegateProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxCreate;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

public abstract class FluxProcessor<IN, OUT>
extends Flux<OUT>
implements Processor<IN, OUT>,
Scannable,
Disposable,
Trackable,
MultiProducer {
    public static <T> FluxProcessor<Publisher<? extends T>, T> switchOnNext() {
        UnicastProcessor emitter = UnicastProcessor.create();
        FluxProcessor p = FluxProcessor.wrap(emitter, FluxProcessor.switchOnNext(emitter));
        return p;
    }

    public static <IN, OUT> FluxProcessor<IN, OUT> wrap(Subscriber<IN> upstream, Publisher<OUT> downstream) {
        return new DelegateProcessor<IN, OUT>(downstream, upstream);
    }

    @Deprecated
    public FluxProcessor<IN, OUT> connect() {
        this.onSubscribe(Operators.emptySubscription());
        return this;
    }

    @Deprecated
    public final BlockingSink<IN> connectSink() {
        return this.connectSink(true);
    }

    @Deprecated
    public final BlockingSink<IN> connectSink(boolean autostart) {
        return BlockingSink.create(this, autostart);
    }

    @Override
    public void dispose() {
        this.onError(new CancellationException("Disposed"));
    }

    @Override
    public long downstreamCount() {
        return this.inners().count();
    }

    public int getBufferSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Deprecated
    public final long getCapacity() {
        return this.getBufferSize();
    }

    @Override
    public Throwable getError() {
        return null;
    }

    @Override
    public boolean hasDownstreams() {
        return this.downstreamCount() != 0L;
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.empty();
    }

    @Override
    @Deprecated
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    public boolean isSerialized() {
        return false;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case TERMINATED: {
                return this.isTerminated();
            }
            case ERROR: {
                return this.getError();
            }
            case CAPACITY: {
                return this.getBufferSize();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public Iterator<?> downstreams() {
        return this.inners().iterator();
    }

    public final FluxProcessor<IN, OUT> serialize() {
        return new DelegateProcessor(this, Operators.serialize(this));
    }

    public final FluxSink<IN> sink() {
        return this.sink(FluxSink.OverflowStrategy.IGNORE);
    }

    public final FluxSink<IN> sink(FluxSink.OverflowStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy");
        if (this.getBufferSize() == Integer.MAX_VALUE) {
            strategy = FluxSink.OverflowStrategy.IGNORE;
        }
        FluxCreate.BaseSink s = FluxCreate.createSink(this, strategy);
        this.onSubscribe(s);
        if (s.isCancelled() || this.isSerialized() && this.getBufferSize() == Integer.MAX_VALUE) {
            return s;
        }
        return new FluxCreate.SerializedSink(s);
    }

    public void subscribe(Subscriber<? super OUT> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
    }
}

