/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import reactor.core.Scannable;
import reactor.core.publisher.FluxFilter;
import reactor.core.publisher.ParallelFlux;

final class ParallelFilter<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;
    final Predicate<? super T> predicate;

    ParallelFilter(ParallelFlux<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public Object scan(Scannable.Attr key) {
        switch (key) {
            case PARENT: {
                return this.source;
            }
            case PREFETCH: {
                return this.getPrefetch();
            }
        }
        return null;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxFilter.FilterSubscriber<T>(subscribers[i], this.predicate);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }
}

