/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.context.notification.NotificationHelper;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationFiringProcessingPhase<Template extends MessageProcessTemplate>
implements MessageProcessPhase<Template>,
Comparable<MessageProcessPhase>,
MuleContextAware {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<ServerNotificationManager, NotificationHelper> notificationHelpers = new ConcurrentHashMap();
    protected MuleContext muleContext;

    protected void fireNotification(Object source, Event event, FlowConstruct flow, int action) {
        try {
            if (event == null && (event = Event.getCurrentEvent()) == null) {
                return;
            }
            this.getNotificationHelper(this.muleContext.getNotificationManager()).fireNotification(source, event, flow, action);
        }
        catch (Exception e) {
            this.logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
        NotificationHelper notificationHelper = this.notificationHelpers.get(serverNotificationManager);
        if (notificationHelper == null) {
            notificationHelper = new NotificationHelper(serverNotificationManager, ConnectorMessageNotification.class, false);
            this.notificationHelpers.putIfAbsent(serverNotificationManager, notificationHelper);
        }
        return notificationHelper;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

