/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.policy.Policy;
import org.mule.runtime.core.policy.PolicyEventConverter;
import org.mule.runtime.core.policy.PolicyStateHandler;
import org.mule.runtime.core.policy.PolicyStateId;

public class OperationPolicyProcessor
implements Processor {
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public OperationPolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public Event process(Event operationEvent) throws MuleException {
        try {
            PolicyStateId policyStateId = new PolicyStateId(operationEvent.getContext().getId(), this.policy.getPolicyId());
            Optional<Event> latestPolicyState = this.policyStateHandler.getLatestState(policyStateId);
            Event variablesProviderEvent = latestPolicyState.orElseGet(() -> Event.builder(operationEvent.getContext()).message(Message.of(null)).build());
            this.policyStateHandler.updateState(policyStateId, variablesProviderEvent);
            Event policyEvent = this.policyEventConverter.createEvent(operationEvent, variablesProviderEvent);
            Processor operationCall = this.buildOperationExecutionWithPolicyFunction(this.nextProcessor, operationEvent);
            this.policyStateHandler.updateNextOperation(policyStateId.getExecutionIndentifier(), operationCall);
            return this.executePolicyChain(operationEvent, policyStateId, policyEvent);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(e);
        }
    }

    private Event executePolicyChain(Event operationEvent, PolicyStateId policyStateId, Event policyEvent) throws MuleException {
        Event policyChainResult = this.policy.getPolicyChain().process(policyEvent);
        this.policyStateHandler.updateState(policyStateId, policyChainResult);
        return this.policyEventConverter.createEvent(policyChainResult, operationEvent);
    }

    private Processor buildOperationExecutionWithPolicyFunction(Processor nextOperation, Event operationEvent) throws Exception {
        return policyExecuteNextEvent -> {
            try {
                PolicyStateId policyStateId = new PolicyStateId(policyExecuteNextEvent.getContext().getId(), this.policy.getPolicyId());
                this.policyStateHandler.updateState(policyStateId, policyExecuteNextEvent);
                Event operationResult = nextOperation.process(this.policyEventConverter.createEvent(policyExecuteNextEvent, operationEvent));
                return this.policyEventConverter.createEvent(operationResult, policyExecuteNextEvent);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        };
    }
}

