/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.message;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.core.util.message.MessageUtils;
import org.mule.runtime.core.util.message.ResultToMessageListIterator;
import org.mule.runtime.core.util.message.ResultsToMessageCollection;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class ResultsToMessageList
extends ResultsToMessageCollection
implements List<Message> {
    private final List<Result> delegate;

    public ResultsToMessageList(List<Result> delegate, CursorProviderFactory cursorProviderFactory, Event event) {
        super(delegate, cursorProviderFactory, event);
        this.delegate = delegate;
    }

    @Override
    public void add(int index, Message element) {
        this.delegate.add(index, Result.builder((Message)element).build());
    }

    @Override
    public boolean addAll(int index, Collection<? extends Message> c) {
        return this.delegate.addAll(index, this.toResults(c));
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Message) {
            return this.delegate.indexOf(Result.builder((Message)((Message)o)).build());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Message) {
            return this.delegate.lastIndexOf(Result.builder((Message)((Message)o)).build());
        }
        return -1;
    }

    @Override
    public void sort(Comparator<? super Message> c) {
        this.delegate.sort((o1, o2) -> c.compare(MessageUtils.toMessage(o1, this.cursorProviderFactory, this.event), MessageUtils.toMessage(o2, this.cursorProviderFactory, this.event)));
    }

    @Override
    public Message get(int index) {
        return MessageUtils.toMessage(this.delegate.get(index), this.cursorProviderFactory, this.event);
    }

    @Override
    public Message set(int index, Message message) {
        Result previous = this.delegate.set(index, Result.builder((Message)message).build());
        return previous != null ? MessageUtils.toMessage(previous, this.cursorProviderFactory, this.event) : null;
    }

    @Override
    public Message remove(int index) {
        Result previous = this.delegate.remove(index);
        return previous != null ? MessageUtils.toMessage(previous, this.cursorProviderFactory, this.event) : null;
    }

    @Override
    public ListIterator<Message> listIterator() {
        return new ResultToMessageListIterator(this.delegate.listIterator(), this.cursorProviderFactory, this.event);
    }

    @Override
    public ListIterator<Message> listIterator(int index) {
        return new ResultToMessageListIterator(this.delegate.listIterator(index), this.cursorProviderFactory, this.event);
    }

    @Override
    public List<Message> subList(int fromIndex, int toIndex) {
        return new ResultsToMessageList(this.delegate.subList(fromIndex, toIndex), this.cursorProviderFactory, this.event);
    }
}

