/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.runtime.module.artifact.classloader.ResourceReleaser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceReleaser
implements ResourceReleaser {
    public static final String DIAGNOSABILITY_BEAN_NAME = "diagnosability";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void release() {
        this.deregisterJdbcDrivers();
        this.cleanUpResourceBundle();
    }

    private void cleanUpResourceBundle() {
        try {
            ResourceBundle.clearCache(this.getClass().getClassLoader());
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clean up ResourceBundle. This can cause a memory leak.", (Throwable)e);
        }
        try {
            Field nonExistentBundleField = ResourceBundle.class.getDeclaredField("NONEXISTENT_BUNDLE");
            nonExistentBundleField.setAccessible(true);
            ResourceBundle resourceBundle = (ResourceBundle)nonExistentBundleField.get(null);
            Field cacheKeyField = ResourceBundle.class.getDeclaredField("cacheKey");
            cacheKeyField.setAccessible(true);
            cacheKeyField.set(resourceBundle, null);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't clean up ResourceBundle references. This can cause a memory leak.", (Throwable)e);
        }
    }

    private void deregisterJdbcDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (this.isDriverLoadedByThisClassLoader(driver)) {
                this.doDeregisterDriver(driver);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug(String.format("Skipping deregister driver %s. It wasn't loaded by the classloader of the artifact being released.", driver.getClass()));
        }
    }

    private boolean isDriverLoadedByThisClassLoader(Driver driver) {
        for (ClassLoader driverClassLoader = driver.getClass().getClassLoader(); driverClassLoader != null; driverClassLoader = driverClassLoader.getParent()) {
            if (driverClassLoader != this.getClass().getClassLoader()) continue;
            return true;
        }
        return false;
    }

    private void doDeregisterDriver(Driver driver) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Deregistering driver: {}", driver.getClass());
            }
            DriverManager.deregisterDriver(driver);
            if (this.isOracleDriver(driver)) {
                this.deregisterOracleDiagnosabilityMBean();
            }
            if (this.isMySqlDriver(driver)) {
                this.shutdownMySqlAbandonedConnectionCleanupThread();
            }
            if (this.isDerbyEmbeddedDriver(driver)) {
                this.leakPreventionForDerbyEmbeddedDriver();
            }
        }
        catch (Exception e) {
            this.logger.warn(String.format("Can not deregister driver %s. This can cause a memory leak.", driver.getClass()), (Throwable)e);
        }
    }

    private boolean isOracleDriver(Driver driver) {
        return this.isDriver(driver, "oracle.jdbc.OracleDriver");
    }

    private boolean isMySqlDriver(Driver driver) {
        return this.isDriver(driver, "com.mysql.jdbc.Driver");
    }

    private boolean isDerbyEmbeddedDriver(Driver driver) {
        return this.isDriver(driver, "org.apache.derby.jdbc.EmbeddedDriver");
    }

    private boolean isDriver(Driver driver, String expectedDriverClass) {
        try {
            return driver.getClass().getClassLoader().loadClass(expectedDriverClass).isAssignableFrom(driver.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void deregisterOracleDiagnosabilityMBean() {
        ClassLoader cl = this.getClass().getClassLoader();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", DIAGNOSABILITY_BEAN_NAME);
        keys.put("name", cl.getClass().getName() + "@" + Integer.toHexString(cl.hashCode()).toLowerCase());
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jdbc", keys));
        }
        catch (InstanceNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("No Oracle's '%s' MBean found.", DIAGNOSABILITY_BEAN_NAME));
            }
        }
        catch (Throwable e) {
            this.logger.warn("Unable to unregister Oracle's mbeans", e);
        }
    }

    private void leakPreventionForDerbyEmbeddedDriver() {
        try {
            Class<?> abandonedConnectionCleanupThreadClass = Class.forName("org.apache.derby.jdbc.EmbeddedDriver", false, this.getClass().getClassLoader());
            Object driverObject = abandonedConnectionCleanupThreadClass.newInstance();
            if (this.hasDeclaredMethod(abandonedConnectionCleanupThreadClass, "connect", String.class, Properties.class)) {
                Method m = abandonedConnectionCleanupThreadClass.getDeclaredMethod("connect", String.class, Properties.class);
                m.invoke(driverObject, "jdbc:derby:;shutdown=true", null);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Unable to unregister Derby's embedded driver", e);
        }
    }

    private boolean hasDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    private void shutdownMySqlAbandonedConnectionCleanupThread() {
        try {
            Class<?> classAbandonedConnectionCleanupThread = this.getClass().getClassLoader().loadClass("com.mysql.jdbc.AbandonedConnectionCleanupThread");
            Method methodShutdown = classAbandonedConnectionCleanupThread.getMethod("shutdown", new Class[0]);
            methodShutdown.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.warn("Unable to shutdown MySql's AbandonedConnectionCleanupThread", (Throwable)e);
        }
    }
}

